/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package applyconfiguration

import (
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	v1 "k8s.io/ingress-nginx/internal/checksum/ingress/apis/checksum/v1"
	checksumv1 "k8s.io/ingress-nginx/internal/checksum/ingress/client/applyconfiguration/checksum/v1"
)

// ForKind returns an apply configuration type for the given GroupVersionKind, or nil if no
// apply configuration type exists for the given GroupVersionKind.
func ForKind(kind schema.GroupVersionKind) interface{} {
	switch kind {
	// Group=tengine.taobao.org, Version=v1
	case v1.SchemeGroupVersion.WithKind("IngressCheckSum"):
		return &checksumv1.IngressCheckSumApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("IngressCheckSumSpec"):
		return &checksumv1.IngressCheckSumSpecApplyConfiguration{}

	}
	return nil
}
