<!--
This changelog should always be read on `master` branch. Its contents on other branches
does not necessarily reflect the changes.
-->

# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.4.0] - 2021-12-10

### Added

- Documents optimization

### Changed

- Upgrade golang version from 1.13 to 1.17
- mod_markdown: upgrade bluemonday version to 1.0.16
- Optimize mutex
- Improve Makefile and pre-commit

## [v1.3.0] - 2021-09-16

### Added
- Support basic route rules that are similar to k8s ingress rules
- Documents optimization

### Changed
- Ignore GREASE values for JA3 fingerprint


## [v1.2.0] - 2021-06-21

### Added
- Set GOMAXPROCS according to real CPU quota if running on container 
- Support condition primitive bfe_time_range/bfe_periodic_time_range
- Support URI hash strategy
- mod_block: support global request rules and ALLOW action
- mod_header: support variables about client certificate
- mod_access: support log to single file and stdout

### Changed
- Change primitive params of req_context_value_in


## [v1.1.0] - 2021-04-08

### Added
- Support JA3 fingerprint for SSL/TLS client
- Support Slow‑Start to allow a backend instance gradually recover its weight
- Add maxConnPerHost to limit the number of connections to a backend
- mod_header: add header renaming actions
- Merge some updates from golang/net/textproto
- Merge some updates from golang/net/http
- Merge some updates from golang/net/http2
- Documents optimization

### Changed
- Change outlierDetectionLevel to OutlierDetectionHttpCode

### Fixed
- Fix panic when write internal response timeout
- Fix unit test in bfe_spdy/frame_test.go under go 1.16

### Security
- Fix config loading for multi-value option


## [v1.0.0] - 2021-01-15

### Added
- Add condition primitive: req_path_contain/req_path_element_prefix_in/req_context_value_in
- Add outlier detection options
- Add mod_waf with rule to detect exploitation of "Shellshock" GNU Bash RCE vulnerability.

### Fixed
- Fix build issue under go1.15 environment
- Fix processing X-Forwarded-For header value
- Fix write timeout of internal response generated by bfe


## [v0.12.0] - 2020-09-03

### Added
- Support gRPC over HTTP/2
- Support communication with FastCGI server
- Reduce objects number by release some objects that are not used as soon as possible
- Replace ffjson with json-iterator 
- net/textproto: turn an ancient DoS BUG annotation into a comment
- Optimize processing of new connections under PROXY mode
- Support integration testing in CI


## [v0.11.0] - 2020-07-24

### Added
- Add mod_cors to enable cross-origin resource sharing
- Add mod_secure_link to check authenticity and limit lifetime of links
- Support PROXY protocol for TCP connections to backend
- Support checking revocation status of the client certificate
- mod_auth_request: send request with X-Forwarded-Method/X-Forwarded-Uri headers
- mod_userid: support global rules
- mod_key_log: support conditional logging
- Add arm64 support for goreleaser

### Changed
- Create listeners in the final initialization step
- Change package name to 'github.com/bfenetworks/bfe'

### Removed
- Drops words like blacklist from programming to make vocabulary more inclusive
- Remove legacy signature of response

### Fixed
- Fix getTransport() and modify transports map with write lock

### Security
- Fix textproto: not normalize headers with spaces before the colon (CVE-2019-16276)


## [v0.10.0] - 2020-05-25  
### Added
- mod_auth_request: authorize clients based on thirdparty authorization service
- mod_trace: support tracing based on Elastic APM
- mod_compress: support brotli algorithm
- mod_rewrite: add HostSuffixReplace action
- Add condition primitive: req_host_tag_in/req_host_suffix_in
- Add static content of website based on mkdocs
- Documents optimization

### Changed
- Refactor and simplify mod_auth_jwt

### Removed
- Remove legacy type of Layer4LoadBalancer 


## [v0.9.0] - 2020-04-16
### Added
- Support loading dynamic modules that may be written and complied by thirdparty vendors
- Add mod_auth_jwt for JWT authentication
- mod_trace: support distributed tracing based on jaeger
- mod_doh: support timeout for DNS requests
- mod_doh: support edns-client-subnet (ECS)
- mod_doh: optimize max-age for DoH response
- Optimize textproto reader cache
- Documents optimization

### Changed
- Change base directory of ServerCertFile/ServerKeyFile to ConfRoot

### Fixed
- Fix failed unit tests about parsing request line under go1.14 environment


## [v0.8.0] - 2020-03-27
### Added
- Add mod_trace for distributed tracing based on zipkin
- Add mod_doh for processing DNS over HTTPS(DoH) requests
- Support TLS protocol with SM related ciphersuites
- mod_header: add cookie related actions
- Documents optimization

### Changed
- Disable sanitization of cookie value


## [v0.7.0] - 2020-02-26
### Added
- mod_access support NCSA Common Log Format(CLF) and W3C Extended Log Format(ELF)
- mod_static suuport HTTP HEAD method
- Add mod_userid for client identification
- Add mod_tag for tagging and tracking groups of requests
- http cookie: support Expires attribute in GMT format
- http cookie: support SameSite attribute 
- Add static check in Makefile
- Compiling on Windows OS is supported
- Documents optimization

### Fixed
- Fix a bug that causes invalid ips are parsed and treated as domain names


## [v0.6.0] - 2020-01-21
### Added
- Add mod_prison to limit the amount of requests a user can make in a given period of time.
- Add condition primitive: ses_tls_sni_in/ses_tls_client_auth/ses_tls_client_ca_in
- Add tls mutual authentication
- mod_header support client cert related variables
- mod_header support geo related variables
- mod_static support customized mime rules
- mod_static allow sending precompressed files instead of regular files
- Expose information about module handlers in web monitor
- Optimize number of accept goroutines
- Optimize lock of bfe_balance.BalTable
- Optimize io.Copy while forwarding responses
- Compiling on Mac OS is supported
- Documents optimization

### Changed
- Change default Layer4LoadBalancer to NONE
- Upgrade from go1.12 to go1.13


## [v0.5.0] - 2019-12-12
### Added
- Add mod_geo to determine user geolocation by MaxMind database
- Add mod_auth_basic to restrict access from unknown users
- Add mod_compress to compress response by customize rules
- Add mod_errors to replace unexpected resposne
- mod_static detect content type based on file extension or content
- Expose pprof items in web monitor
- Add default resFlushInterval for SSE(Server-Sent Events) response
- Support X-Forwarded-Host Header
- Support docker image in Makefile
- Documents optimization

### Changed
- Change default monitor port to 8421
- Rename HANDLE_READ_BACKEND to HANDLE_READ_RESPONSE

### Removed
- Remove some legacy fields from mod_access


## [v0.4.0] - 2019-11-19
### Added
- Expose metrics in prometheus text-based format
- Add default value for core configs to reduce configuration cost
- Add mod_static to serve static content by customize rules
- Documents optimization

### Changed
- mod_logid: random logid in hex encoding format

### Removed
- Remove signal SIGSTKFLT


## [v0.3.0] - 2019-10-17

### Added
- Add condition primitive: req_cip_hash_in/req_header_value_hash_in/req_cookie_value_hash_in/req_query_value_hash_in
- Add mod_header variable: bfe_log_id
- Add mod_http_code to maintain basic status about response forwarded

### Security
- Fix http2: limit number of control frames in server send queue (CVE-2019-9512, CVE-2019-9514)


## [v0.2.0] - 2019-09-26

### Added
- Add proxy protocol to be compatible with F5 BigIP/Citrix ADC etc
- Add mod_access to write request/session log in customized format
- Add mod_key_log to wirte tls key log so that external programs(eg. wireshark) can decrypt TLS connections for trouble shooting
- Add security grade 'A+' in tls
- Add condition primitive: req_query_value_contain/req_header_value_contain/req_cookie_value_contain
- Documents optimization

### Changed
- reverseproxy: flush response header immediately if flushInterval<0


## [v0.1.0] - 2019-08-01

### Added
- Multiple protocols supported, including HTTP, HTTPS, SPDY, HTTP2, WebSocket, TLS, etc
- Content based routing, support user-defined routing rule in advanced domain-specific language
- Support multiple load balancing policies
- Flexible plugin framework to extend functionality. Based on the framework, developer can add new features rapidly
- Detailed built-in metrics available for service status monitor

<<<<<<< HEAD
=======
[v1.4.0]: https://github.com/bfenetworks/bfe/compare/v1.3.0...v1.4.0
>>>>>>> release/v1.4.0
[v1.3.0]: https://github.com/bfenetworks/bfe/compare/v1.2.0...v1.3.0
[v1.2.0]: https://github.com/bfenetworks/bfe/compare/v1.1.0...v1.2.0
[v1.1.0]: https://github.com/bfenetworks/bfe/compare/v1.0.0...v1.1.0
[v1.0.0]: https://github.com/bfenetworks/bfe/compare/v0.12.0...v1.0.0
[v0.12.0]: https://github.com/bfenetworks/bfe/compare/v0.11.0...v0.12.0
[v0.11.0]: https://github.com/bfenetworks/bfe/compare/v0.10.0...v0.11.0
[v0.10.0]: https://github.com/bfenetworks/bfe/compare/v0.9.0...v0.10.0
[v0.9.0]: https://github.com/bfenetworks/bfe/compare/v0.8.0...v0.9.0
[v0.8.0]: https://github.com/bfenetworks/bfe/compare/v0.7.0...v0.8.0
[v0.7.0]: https://github.com/bfenetworks/bfe/compare/v0.6.0...v0.7.0
[v0.6.0]: https://github.com/bfenetworks/bfe/compare/v0.5.0...v0.6.0
[v0.5.0]: https://github.com/bfenetworks/bfe/compare/v0.4.0...v0.5.0
[v0.4.0]: https://github.com/bfenetworks/bfe/compare/v0.3.0...v0.4.0
[v0.3.0]: https://github.com/bfenetworks/bfe/compare/v0.2.0...v0.3.0
[v0.2.0]: https://github.com/bfenetworks/bfe/compare/v0.1.0...v0.2.0
[v0.1.0]: https://github.com/bfenetworks/bfe/releases/tag/v0.1.0
