/// <reference types="node" />
export interface UplogOption {
    appName: string;
    appVersion: string;
    mode: string;
    bufferSize?: number;
}
interface UplogEntry {
    log_type: LogType;
    os_name?: string;
    os_version?: string;
    sdk_name?: string;
    sdk_version?: string;
    http_client?: string;
    http_client_version?: string;
    up_time?: number;
}
export interface RequestUplogEntry extends UplogEntry {
    status_code?: number;
    req_id?: string;
    host: string;
    port: number;
    method: string;
    path: string;
    remote_ip?: string;
    total_elapsed_time: number;
    bytes_sent?: number;
    error_type?: ErrorType;
    error_description?: string;
}
export declare enum LogType {
    Request = 0
}
export declare enum ErrorType {
}
export declare class UplogBuffer {
    private readonly option;
    private uploadBufferedEntries;
    private uploadBufferFd;
    constructor(option: UplogOption);
    log(entry: UplogEntry): Promise<void>;
    private flushBufferToLogFile;
    exportLogs(f: (buffer: Buffer) => Promise<void>): Promise<void>;
    private convertUplogEntryToJSON;
}
export {};
//# sourceMappingURL=uplog.d.ts.map