import { Adapter, Object, Domain, ProgressCallback, ObjectHeader } from './adapter';
import { ThrottleGroup, ThrottleOptions } from 'stream-throttle';
export declare class Downloader {
    private readonly adapter;
    private aborted;
    private static readonly userCanceledError;
    constructor(adapter: Adapter);
    getObjectToFile(region: string, object: Object, filePath: string, domain?: Domain, getFileOption?: GetFileOption): Promise<void>;
    private getObjectToFilePath;
    private getObjectToFileWriteStream;
    abort(): void;
}
export interface GetCallback {
    progressCallback?: ProgressCallback;
    headerCallback?: (header: ObjectHeader) => void;
    partGetCallback?: (partSize: number) => void;
}
export interface GetFileOption {
    recoveredFrom?: number | boolean;
    getCallback?: GetCallback;
    partSize?: number;
    chunkTimeout?: number;
    retriesOnSameOffset?: number;
    downloadThreshold?: number;
    downloadThrottleGroup?: ThrottleGroup;
    downloadThrottleOption?: ThrottleOptions;
}
//# sourceMappingURL=downloader.d.ts.map