
# Changelog

## Version 5.6.2

* build: rename build commands

## Version 5.6.1

* fix: memory leak in sync
* refactor: remove unsused values
* fix: add browserify dev dep

## Version 5.6.0

* build: use browser compatible bundles, fix #122

## Version 5.5.3

* ts: callback argument simplification

## Version 5.5.2

* package: latest dependencies
* test: fix write null in node 14
* ts: enable strict mode
* package: mocha inside package declaration

## Version 5.5.1

Fix
* bom: work with sync module, fix #115

## Version 5.5.0

Feature:
* cast: support for BigInt

## Version 5.4.3

Fix:
* utils: wrongly declared variable in isSymbol

## Version 5.4.2

Fix:
* quoted_match: apply on all types and not just string
* cast: validate and normalize local options

Project management:
* samples: add quoted examples

## Version 5.4.1

* bom: fix ts definition

## Version 5.4.0

* src: complete require in javascript
* bom: new option

## Version 5.3.6

* cast: fix header context property on first record

## Version 5.3.5

* stream: passing options to parent constructor, fix #104

## Version 5.3.4

* src: strengthen conditions
* test: ensure every sample is valid
* package: contributing
* package: code of conduct
* quoted_match: ts types string or RegExp

## Version 5.3.3

* columns: can still access fields with dots, fix #98

## Version 5.3.2

* columns: get on undefined objects, fix #97

## Version 5.3.1

* package: latest dependencies
* package: replace npm ignore with file field
* project: fix license in package.json
* package: simplify pretest command

## Version 5.3.0

New feature:
* quote: may be a boolean value
* delimiter: accept buffer and enforce validation
* delimiter: disabled if value is empty
* cast: overwrite options if value is an object

Fix:
* record_delimiter: enforce validation

Project management:
* package: latest dependencies
* ts: type tests

## Version 5.2.0

Fix:
* escape: enforce validation

Project management:
* babel: include .babelrc to git
* ts: rename RowDelimiter to RecordDelimiter
* ts: convert camel case to snake case

## Version 5.1.2

Fix:
* write: immutable input chunks

## Version 5.1.1

Fix:
* ts: add casting context missing type

## Version 5.1.0

Fix:
* header: ensure column definition

New features:
* cast: pass context to functions

Minor enhancements:
* write: validate written records
* src: extends stream class

Project management:
* package: latest dev dependencies

## Version 5.0.0

Breaking changes:
* `cast`: was `formatters`
* `record_delimiter`: was `row_delimiter`
* options: instance options stored in snake case
* nodejs: drop support for version 7, use './lib/es5'

New features:
* `quoted_match`: new option
* options: accept snake case and camel case

Minor enhancements:
* stream: pass all options to the transform stream
* stream: use writableObjectMode

Project management:
* package: update license to MIT
* travis: test against Node.js 11
* samples: improve some scripts

## Version 4.3.1

* readme: fix links to project website

## Version 4.3.0

* package: move to csv.js.org

## Version 4.2.0

* `formatters`: new string formatter
* stream: be a much better transform citizen
* package: upgrade to babel 7

## Version 4.1.0

* `columns`: support array with column definition objects
* travis: support Node.js 10
* samples: new formatters script
* samples: update syntax
* package: improve ignore files

## Version 4.0.1

* typescript: reflect latest change in formatters

## Version 4.0.0

Backward incompatibilities:
* `formatters`: rename bool to boolean

New features:
* `formatters`: handle number

Cleanup
* src: cache call to `typeof`
* package: latest dependencies

## Version 3.1.1

* typescript: sync API needs to return a string

## Version 3.1.0

* typescript: add typings

## Version 3.0.0

* Switch linebreak check for `rowDelimiter` check

## Version 2.1.0

* package: allow empty quote value
* package: add ascii option for `rowDelimiter`

## Version 2.0.4

* package: move babel to dev dependencies

## Version 2.0.3

* package: es5 backward compatiblity
* package: ignore yarn lock file

## Version 2.0.2

* package: start running tests in preversion

## Version 2.0.1

* package: new release workflow
* formatters: validate returned value

## 2.0.0

This major version use CoffeeScript 2 which produces a modern JavaScript syntax
(ES6, or ES2015 and later) and break the compatibility with versions of Node.js
lower than 7.6 as well as the browsers. It is however stable in term of API.

* package: use CoffeeScript 2

## v1.1.0

* test: should require handled by mocha
* package: CoffeeScript 2 and use of semver tilde
