// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef __STOUT_OS_ACCESS_HPP__
#define __STOUT_OS_ACCESS_HPP__

#include <string>

#include <stout/error.hpp>
#include <stout/try.hpp>

#ifdef __WINDOWS__
#include <stout/windows.hpp>
#include <stout/internal/windows/longpath.hpp>
#endif // __WINDOWS__

namespace os {

inline Try<bool> access(const std::string& path, int how)
{
  int result;

#ifdef __WINDOWS__
  std::wstring longpath = ::internal::windows::longpath(path);
  result = ::_waccess(longpath.data(), how);
#else
  result = ::access(path.data(), how);
#endif

  if (result < 0) {
    if (errno == EACCES) {
      return false;
    } else {
      return ErrnoError();
    }
  }

  return true;
}

} // namespace os {

#endif // __STOUT_OS_ACCESS_HPP__
