/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import javax.jms.ConnectionFactory;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class DefaultJMSConnectionFactoryResourceReferenceProcessor
implements DeploymentUnitProcessor {
    private static final JMSConnectionFactoryResourceReferenceProcessor RESOURCE_REFERENCE_PROCESSOR = new JMSConnectionFactoryResourceReferenceProcessor();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        EEResourceReferenceProcessorRegistry eeResourceReferenceProcessorRegistry;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() == null && (eeResourceReferenceProcessorRegistry = (EEResourceReferenceProcessorRegistry)deploymentUnit.getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY)) != null) {
            eeResourceReferenceProcessorRegistry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)RESOURCE_REFERENCE_PROCESSOR);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class JMSConnectionFactoryResourceReferenceProcessor
    implements EEResourceReferenceProcessor {
        private static final String TYPE = ConnectionFactory.class.getName();
        private static final InjectionSource INJECTION_SOURCE = new LookupInjectionSource("java:comp/DefaultJMSConnectionFactory");

        private JMSConnectionFactoryResourceReferenceProcessor() {
        }

        public String getResourceReferenceType() {
            return TYPE;
        }

        public InjectionSource getResourceReferenceBindingSource() throws DeploymentUnitProcessingException {
            return INJECTION_SOURCE;
        }
    }
}

