/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.function.Function;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.service.PassiveServiceSupplier;
import org.wildfly.clustering.singleton.Singleton;

public class SingletonMetricExecutor
implements MetricExecutor<Singleton> {
    private final Function<String, ServiceName> serviceNameFactory;

    public SingletonMetricExecutor(Function<String, ServiceName> serviceNameFactory) {
        this.serviceNameFactory = serviceNameFactory;
    }

    public ModelNode execute(OperationContext context, Metric<Singleton> metric) throws OperationFailedException {
        ServiceName name = this.serviceNameFactory.apply(context.getCurrentAddressValue());
        Singleton singleton = SingletonMetricExecutor.findSingleton(context.getServiceRegistry(false), name);
        return metric.execute((Object)singleton);
    }

    private static Singleton findSingleton(ServiceRegistry registry, ServiceName name) {
        try {
            PassiveServiceSupplier singleton = new PassiveServiceSupplier(registry, name.append(new String[]{"singleton"}));
            return (Singleton)singleton.get();
        }
        catch (ServiceNotFoundException e) {
            return (Singleton)registry.getRequiredService(name).getService();
        }
    }
}

