/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.transaction.client.ContextTransactionManager;

@ClientInterceptorPriority(value=200150)
public final class TransactionPostDiscoveryInterceptor
implements EJBClientInterceptor {
    private static final ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
    static final AttachmentKey<TransactionInterceptor.Application> APPLICATION = new AttachmentKey();
    public static final int PRIORITY = 200150;

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        ConcurrentMap<TransactionInterceptor.Application, URI> applications = context.getAttachment(TransactionInterceptor.APPLICATIONS);
        if (applications != null) {
            URI destination = context.getDestination();
            TransactionInterceptor.Application registered = this.updateOrFollowApplication(context, applications, true);
            try {
                context.sendRequest();
            }
            catch (NoSuchEJBException | RequestSendFailedException e) {
                if (registered != null) {
                    applications.remove(registered, destination);
                }
                context.removeAttachment(TransactionInterceptor.APPLICATIONS);
                context.removeAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
                context.removeAttachment(APPLICATION);
                throw e;
            }
        } else {
            context.sendRequest();
        }
    }

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        ConcurrentMap<TransactionInterceptor.Application, URI> applications = context.getAttachment(TransactionInterceptor.APPLICATIONS);
        if (applications != null) {
            URI destination = context.getDestination();
            TransactionInterceptor.Application registered = this.updateOrFollowApplication(context, applications, false);
            try {
                SessionID sessionID = context.proceed();
                return sessionID;
            }
            catch (NoSuchEJBException | RequestSendFailedException e) {
                if (registered != null) {
                    applications.remove(registered, destination);
                }
                throw e;
            }
            finally {
                context.removeAttachment(TransactionInterceptor.APPLICATIONS);
                context.removeAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
            }
        }
        return context.proceed();
    }

    /*
     * Enabled aggressive block sorting
     */
    private TransactionInterceptor.Application updateOrFollowApplication(AbstractInvocationContext context, ConcurrentMap<TransactionInterceptor.Application, URI> applications, boolean register) {
        URI destination = context.getDestination();
        if (destination == null) {
            Logs.TXN.trace("Failed assertion: a destination was supposed ot be present but wasn't");
            return null;
        }
        EJBIdentifier identifier = context.getLocator().getIdentifier();
        TransactionInterceptor.Application application = TransactionInterceptor.toApplication(identifier);
        URI existing = applications.putIfAbsent(application, destination);
        if (existing != null) {
            context.setDestination(existing);
            return null;
        }
        if (!register) return application;
        context.putAttachment(APPLICATION, application);
        return application;
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        ConcurrentMap<TransactionInterceptor.Application, URI> applications = context.getAttachment(TransactionInterceptor.APPLICATIONS);
        TransactionInterceptor.Application application = context.getAttachment(APPLICATION);
        URI destination = context.getDestination();
        try {
            Object object = context.getResult();
            return object;
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (application != null) {
                applications.remove(application, destination);
            }
            throw e;
        }
        finally {
            context.removeAttachment(TransactionInterceptor.APPLICATIONS);
            context.removeAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
            context.removeAttachment(APPLICATION);
        }
    }
}

