/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Map<String, UUID> names;
    private final Map<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(String id, Map<String, UUID> names, Map<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.id = id;
        this.names = Collections.unmodifiableMap(names);
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        return attributeId != null ? this.read(name, this.attributeCache.get((Object)new SessionAttributeKey(this.id, attributeId))) : null;
    }

    private Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw InfinispanWebLogger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id, name);
        }
    }
}

