/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.deployment;

import java.util.HashSet;
import java.util.ListIterator;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ApplicationClientDependencyProcessor
implements DeploymentUnitProcessor {
    public static final ModuleIdentifier CORBA_ID = ModuleIdentifier.create((String)"org.omg.api");
    public static final ModuleIdentifier XNIO = ModuleIdentifier.create((String)"org.jboss.xnio");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader loader = (ModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        moduleSpecification.addSystemDependency(new ModuleDependency(loader, CORBA_ID, false, true, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(loader, XNIO, false, true, true, false));
        HashSet<Object> moduleIdentifiers = new HashSet<Object>();
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        moduleIdentifiers.add(top.getAttachment(Attachments.MODULE_IDENTIFIER));
        for (DeploymentUnit module : top.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
            moduleIdentifiers.add(module.getAttachment(Attachments.MODULE_IDENTIFIER));
        }
        ListIterator iterator = moduleSpecification.getMutableUserDependencies().listIterator();
        while (iterator.hasNext()) {
            ModuleDependency dep = (ModuleDependency)iterator.next();
            ModuleIdentifier identifier = dep.getIdentifier();
            if (!identifier.getName().startsWith("deployment.") || identifier.getName().startsWith("deployment.extension.") || moduleIdentifiers.contains(identifier)) continue;
            iterator.remove();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

