/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class ExpiredBeanRemover<I, T>
implements BeanRemover<I, T> {
    private final BeanFactory<I, T> factory;

    public ExpiredBeanRemover(BeanFactory<I, T> factory) {
        this.factory = factory;
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        Bean<I, T> bean;
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        Bean<I, T> bean2 = bean = entry != null ? this.factory.createBean(id, entry) : null;
        if (bean != null && bean.isExpired()) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Removing expired bean %s", id);
            this.factory.remove(id, listener);
        }
    }
}

