/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class BeanExpirationScheduler<I, T>
implements Scheduler<I> {
    final Map<I, Future<?>> expirationFutures = new ConcurrentHashMap();
    final Batcher<TransactionBatch> batcher;
    final BeanRemover<I, T> remover;
    final ExpirationConfiguration<T> expiration;

    public BeanExpirationScheduler(Batcher<TransactionBatch> batcher, BeanRemover<I, T> remover, ExpirationConfiguration<T> expiration) {
        this.batcher = batcher;
        this.remover = remover;
        this.expiration = expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id) {
        Duration timeout = this.expiration.getTimeout();
        if (!timeout.isNegative()) {
            ExpirationTask task;
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to expire in %s", id, timeout);
            ExpirationTask expirationTask = task = new ExpirationTask(id);
            synchronized (expirationTask) {
                this.expirationFutures.put(id, this.expiration.getExecutor().schedule(task, timeout.toMillis(), TimeUnit.MILLISECONDS));
            }
        }
    }

    @Override
    public void cancel(I id) {
        Future<?> future = this.expirationFutures.remove(id);
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void cancel(Locality locality) {
        for (I id : this.expirationFutures.keySet()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(id)) continue;
            this.cancel(id);
        }
    }

    @Override
    public void close() {
        for (Future<?> future : this.expirationFutures.values()) {
            future.cancel(false);
        }
        for (Future<?> future : this.expirationFutures.values()) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        this.expirationFutures.clear();
    }

    private class ExpirationTask
    implements Runnable {
        private final I id;

        ExpirationTask(I id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", this.id);
            try (Batch batch = BeanExpirationScheduler.this.batcher.createBatch();){
                try {
                    BeanExpirationScheduler.this.remover.remove(this.id, BeanExpirationScheduler.this.expiration.getRemoveListener());
                }
                catch (Throwable e) {
                    InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e, this.id);
                    batch.discard();
                }
            }
            finally {
                ExpirationTask expirationTask = this;
                synchronized (expirationTask) {
                    BeanExpirationScheduler.this.expirationFutures.remove(this.id);
                }
            }
        }
    }
}

