/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.logging;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleNotFoundException;

public class HttpServerLogger_$logger
extends DelegatingBasicLogger
implements HttpServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String modelRequestError = "WFLYDMHTTP0001: Unexpected error executing model request";
    private static final String uploadError = "WFLYDMHTTP0002: Unexpected error executing deployment upload request";
    private static final String consoleModuleNotFound = "WFLYDMHTTP0003: Unable to load console module for slot %s, disabling console";
    private static final String errorContextModuleNotFound = "WFLYDMHTTP0004: Unable to load error context for slot %s, disabling error context.";
    private static final String invalidOperation = "WFLYDMHTTP0005: Invalid operation '%s'";
    private static final String realmNotReadyMessage = "WFLYDMHTTP0006: The security realm is not ready to process requests, see %s";
    private static final String consoleModuleNotFoundMsg = "WFLYDMHTTP0007: No console module available with module name %s";
    private static final String invalidCredentialType = "WFLYDMHTTP0010: Invalid Credential Type '%s'";
    private static final String httpsRedirectNotSupported = "WFLYDMHTTP0011: Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.";
    private static final String sslRequestedNoSslContext = "WFLYDMHTTP0012: A secure socket has been defined for the HTTP interface, however the referenced security realm is not supplying a SSLContext.";
    private static final String invalidUseStreamAsResponseIndex = "WFLYDMHTTP0013: Invalid useStreamIndex value '%d'. The operation response had %d streams attached.";
    private static final String managementHttpServerAlreadyBuild = "WFLYDMHTTP0014: The ManagementHttpServer has already been built using this Builder.";
    private static final String noRealmOrSSLContext = "WFLYDMHTTP0015: No SecurityRealm or SSLContext has been provided.";
    private static final String realmNotReadyForSecuredManagementHandler = "WFLYDMHTTP0016: Your Application Server is running. However you have not yet added any users to be able to access the HTTP management interface. To add a new user execute the %s script within the bin folder of your WildFly installation and enter the requested information. By default the realm name used by WildFly is 'ManagementRealm' and this is already selected by default by the add-user tool.";

    public HttpServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void modelRequestError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.modelRequestError$str(), new Object[0]);
    }

    protected String modelRequestError$str() {
        return modelRequestError;
    }

    @Override
    public final void uploadError(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.uploadError$str(), new Object[0]);
    }

    protected String uploadError$str() {
        return uploadError;
    }

    @Override
    public final void consoleModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.consoleModuleNotFound$str(), (Object)slot);
    }

    protected String consoleModuleNotFound$str() {
        return consoleModuleNotFound;
    }

    @Override
    public final void errorContextModuleNotFound(String slot) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorContextModuleNotFound$str(), (Object)slot);
    }

    protected String errorContextModuleNotFound$str() {
        return errorContextModuleNotFound;
    }

    protected String invalidOperation$str() {
        return invalidOperation;
    }

    @Override
    public final IllegalArgumentException invalidOperation(Throwable cause, String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidOperation$str(), value), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmNotReadyMessage$str() {
        return realmNotReadyMessage;
    }

    @Override
    public final String realmNotReadyMessage(String url) {
        return String.format(this.getLoggingLocale(), this.realmNotReadyMessage$str(), url);
    }

    protected String consoleModuleNotFoundMsg$str() {
        return consoleModuleNotFoundMsg;
    }

    @Override
    public final ModuleNotFoundException consoleModuleNotFoundMsg(String moduleName) {
        ModuleNotFoundException result = new ModuleNotFoundException(String.format(this.getLoggingLocale(), this.consoleModuleNotFoundMsg$str(), moduleName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCredentialType$str() {
        return invalidCredentialType;
    }

    @Override
    public final IllegalArgumentException invalidCredentialType(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCredentialType$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void httpsRedirectNotSupported(InetAddress bindAddress, InetAddress secureBindAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.httpsRedirectNotSupported$str(), (Object)bindAddress, (Object)secureBindAddress);
    }

    protected String httpsRedirectNotSupported$str() {
        return httpsRedirectNotSupported;
    }

    protected String sslRequestedNoSslContext$str() {
        return sslRequestedNoSslContext;
    }

    @Override
    public final IllegalArgumentException sslRequestedNoSslContext() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.sslRequestedNoSslContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidUseStreamAsResponseIndex$str() {
        return invalidUseStreamAsResponseIndex;
    }

    @Override
    public final String invalidUseStreamAsResponseIndex(int index, int available) {
        return String.format(this.getLoggingLocale(), this.invalidUseStreamAsResponseIndex$str(), index, available);
    }

    protected String managementHttpServerAlreadyBuild$str() {
        return managementHttpServerAlreadyBuild;
    }

    @Override
    public final IllegalStateException managementHttpServerAlreadyBuild() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.managementHttpServerAlreadyBuild$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noRealmOrSSLContext$str() {
        return noRealmOrSSLContext;
    }

    @Override
    public final IllegalStateException noRealmOrSSLContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noRealmOrSSLContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String realmNotReadyForSecuredManagementHandler$str() {
        return realmNotReadyForSecuredManagementHandler;
    }

    @Override
    public final String realmNotReadyForSecuredManagementHandler(String scriptFile) {
        return String.format(this.getLoggingLocale(), this.realmNotReadyForSecuredManagementHandler$str(), scriptFile);
    }
}

