/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.security.Policy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.security.ApplicationSecurityDomainConfig;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.security.auth.server.SecurityDomain;

public class ApplicationSecurityDomainDefinition
extends SimpleResourceDefinition {
    public static final String APPLICATION_SECURITY_DOMAIN_CAPABILITY = "org.wildfly.ejb3.application-security-domain";
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.application-security-domain", (boolean)true, ApplicationSecurityDomainService.ApplicationSecurityDomain.class).build();
    private static final String SECURITY_DOMAIN_CAPABILITY = "org.wildfly.security.security-domain";
    private static final String JACC_POLICY_CAPABILITY = "org.wildfly.security.jacc-policy";
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.ejb3.application-security-domain", true)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    private static StringListAttributeDefinition REFERENCING_DEPLOYMENTS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("referencing-deployments").setStorageRuntime()).build();
    static final SimpleAttributeDefinition ENABLE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jacc", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN, ENABLE_JACC};
    static final ApplicationSecurityDomainDefinition INSTANCE = new ApplicationSecurityDomainDefinition();
    private static final Set<ApplicationSecurityDomainConfig> knownApplicationSecurityDomains = Collections.synchronizedSet(new HashSet());

    private ApplicationSecurityDomainDefinition() {
        this(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"application-security-domain"), EJB3Extension.getResourceDescriptionResolver("application-security-domain")).setCapabilities(new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("ejb3", "application-security-domain", false, false, false)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("ejb3", "application-security-domain"))}), new AddHandler());
    }

    private ApplicationSecurityDomainDefinition(SimpleResourceDefinition.Parameters parameters, AbstractAddStepHandler add) {
        super(parameters.setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new RemoveHandler(add)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        knownApplicationSecurityDomains.clear();
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)handler);
        }
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)REFERENCING_DEPLOYMENTS, (OperationStepHandler)new ReferencingDeploymentsHandler());
        }
    }

    Function<String, ApplicationSecurityDomainConfig> getKnownSecurityDomainFunction() {
        return name -> {
            Set<ApplicationSecurityDomainConfig> set = knownApplicationSecurityDomains;
            synchronized (set) {
                for (ApplicationSecurityDomainConfig applicationSecurityDomainConfig : knownApplicationSecurityDomains) {
                    if (!applicationSecurityDomainConfig.isSameDomain((String)name)) continue;
                    return applicationSecurityDomainConfig;
                }
            }
            return null;
        };
    }

    private static class ReferencingDeploymentsHandler
    implements OperationStepHandler {
        private ReferencingDeploymentsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isDefaultRequiresRuntime()) {
                context.addStep((ctx, op) -> {
                    Service service;
                    RuntimeCapability runtimeCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
                    ServiceName serviceName = runtimeCapability.getCapabilityServiceName(ApplicationSecurityDomainService.ApplicationSecurityDomain.class);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ServiceController controller = serviceRegistry.getRequiredService(serviceName);
                    ModelNode deploymentList = new ModelNode();
                    if (controller.getState() == ServiceController.State.UP && (service = controller.getService()) instanceof ApplicationSecurityDomainService) {
                        for (String current : ((ApplicationSecurityDomainService)service).getDeployments()) {
                            deploymentList.add(current);
                        }
                    }
                    context.getResult().set(deploymentList);
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        protected RemoveHandler(AbstractAddStepHandler addOperation) {
            super(addOperation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            HashSet applicationSecurityDomainConfigs;
            super.performRemove(context, operation, model);
            Set set = knownApplicationSecurityDomains;
            synchronized (set) {
                applicationSecurityDomainConfigs = new HashSet(knownApplicationSecurityDomains);
            }
            for (ApplicationSecurityDomainConfig domain : applicationSecurityDomainConfigs) {
                if (!domain.isSameDomain(context.getCurrentAddressValue())) continue;
                knownApplicationSecurityDomains.remove(domain);
            }
        }

        protected ServiceName serviceName(String name) {
            RuntimeCapability dynamicCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(name);
            return dynamicCapability.getCapabilityServiceName(ApplicationSecurityDomainService.ApplicationSecurityDomain.class);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private AddHandler() {
            super(ATTRIBUTES);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            ModelNode model = resource.getModel();
            boolean enableJacc = false;
            if (model.hasDefined(ENABLE_JACC.getName())) {
                enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            }
            knownApplicationSecurityDomains.add(new ApplicationSecurityDomainConfig(context.getCurrentAddressValue(), enableJacc));
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
            boolean enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            RuntimeCapability runtimeCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName serviceName = runtimeCapability.getCapabilityServiceName(ApplicationSecurityDomainService.ApplicationSecurityDomain.class);
            ApplicationSecurityDomainService applicationSecurityDomainService = new ApplicationSecurityDomainService(enableJacc);
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)applicationSecurityDomainService).setInitialMode(ServiceController.Mode.LAZY);
            serviceBuilder.addDependency(context.getCapabilityServiceName(ApplicationSecurityDomainDefinition.SECURITY_DOMAIN_CAPABILITY, securityDomain, SecurityDomain.class), SecurityDomain.class, applicationSecurityDomainService.getSecurityDomainInjector());
            if (model.hasDefined(ENABLE_JACC.getName()) && ENABLE_JACC.resolveModelAttribute(context, model).asBoolean()) {
                serviceBuilder.requires(context.getCapabilityServiceName(ApplicationSecurityDomainDefinition.JACC_POLICY_CAPABILITY, Policy.class));
            }
            serviceBuilder.install();
        }
    }
}

