/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.JmxWorker;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.mbean.MCounterImpl;
import io.smallrye.metrics.mbean.MGaugeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public class JmxRegistrar {
    public void init() throws IOException {
        this.register("base-metrics.properties", MetricRegistries.get(MetricRegistry.Type.BASE));
        this.register("vendor-metrics.properties", MetricRegistries.get(MetricRegistry.Type.VENDOR));
    }

    private void register(String propertiesFile, MetricRegistry registry) throws IOException {
        List<ExtendedMetadata> configs = this.findMetadata(propertiesFile);
        for (ExtendedMetadata config : configs) {
            this.register(registry, config);
        }
    }

    void register(MetricRegistry registry, ExtendedMetadata config) {
        Object metric = null;
        switch (config.getTypeRaw()) {
            case COUNTER: {
                metric = new MCounterImpl(JmxWorker.instance(), config.getMbean());
                break;
            }
            case GAUGE: {
                metric = new MGaugeImpl(JmxWorker.instance(), config.getMbean());
            }
        }
        if (metric != null) {
            registry.register((Metadata)config, metric);
        }
    }

    private List<ExtendedMetadata> findMetadata(String propertiesFile) throws IOException {
        try (InputStream propertiesResource = this.getResource("/io/smallrye/metrics/" + propertiesFile);){
            if (propertiesResource == null) {
                List<ExtendedMetadata> list = Collections.emptyList();
                return list;
            }
            List<ExtendedMetadata> resultList = this.loadMetadataFromProperties(propertiesResource);
            JmxWorker.instance().expandMultiValueEntries(resultList);
            List<ExtendedMetadata> list = resultList;
            return list;
        }
    }

    List<ExtendedMetadata> loadMetadataFromProperties(InputStream propertiesResource) throws IOException {
        Properties baseMetricsProps = new Properties();
        baseMetricsProps.load(propertiesResource);
        Map<String, List<MetricProperty>> parsedMetrics = baseMetricsProps.entrySet().stream().map(MetricProperty::new).collect(Collectors.groupingBy(MetricProperty::getMetricName));
        return parsedMetrics.entrySet().stream().map(this::metadataOf).sorted(Comparator.comparing(e -> e.getName())).collect(Collectors.toList());
    }

    private InputStream getResource(String location) {
        InputStream is = this.getClass().getResourceAsStream(location);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        }
        return is;
    }

    private ExtendedMetadata metadataOf(Map.Entry<String, List<MetricProperty>> metadataEntry) {
        String name = metadataEntry.getKey();
        HashMap entryProperties = new HashMap();
        metadataEntry.getValue().forEach(prop -> entryProperties.put(prop.propertyKey, prop.propertyValue));
        ExtendedMetadata meta = new ExtendedMetadata(name, this.metricTypeOf((String)entryProperties.get("type")));
        meta.setMbean((String)entryProperties.get("mbean"));
        meta.setDisplayName((String)entryProperties.get("displayName"));
        meta.setDescription((String)entryProperties.get("description"));
        meta.setUnit((String)entryProperties.get("unit"));
        meta.setMulti("true".equalsIgnoreCase((String)entryProperties.get("multi")));
        return meta;
    }

    MetricType metricTypeOf(String type) {
        return MetricType.valueOf((String)type.toUpperCase());
    }

    private static class MetricProperty {
        String metricName;
        String propertyKey;
        String propertyValue;

        MetricProperty(Map.Entry<Object, Object> keyValue) {
            String key = (String)keyValue.getKey();
            int propertyIdEnd = key.lastIndexOf(46);
            this.metricName = key.substring(0, propertyIdEnd);
            this.propertyKey = key.substring(propertyIdEnd + 1);
            this.propertyValue = (String)keyValue.getValue();
        }

        String getMetricName() {
            return this.metricName;
        }
    }
}

