/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactoryServiceConfiguratorProvider;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.SSOManagerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionIdGeneratorServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionListenerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryServiceConfigurator;

public class DistributableSingleSignOnManagerServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<SingleSignOnManager> {
    private final SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>> manager;
    private final SupplierDependency<SessionManagerRegistry> registry;
    private final Collection<CapabilityServiceConfigurator> configurators;

    public DistributableSingleSignOnManagerServiceConfigurator(ServiceName name, String serverName, String hostName, SSOManagerFactoryServiceConfiguratorProvider provider) {
        super(name);
        CapabilityServiceConfigurator factoryConfigurator = provider.getServiceConfigurator(hostName);
        ServiceName generatorServiceName = name.append(new String[]{"generator"});
        SessionIdGeneratorServiceConfigurator generatorConfigurator = new SessionIdGeneratorServiceConfigurator(generatorServiceName, serverName);
        ServiceSupplierDependency factoryDependency = new ServiceSupplierDependency((ServiceNameProvider)factoryConfigurator);
        ServiceSupplierDependency generatorDependency = new ServiceSupplierDependency(generatorServiceName);
        ServiceName managerServiceName = name.append(new String[]{"manager"});
        SSOManagerServiceConfigurator managerConfigurator = new SSOManagerServiceConfigurator(managerServiceName, factoryDependency, (SupplierDependency<SessionIdGenerator>)generatorDependency, () -> null);
        ServiceSupplierDependency managerDependency = new ServiceSupplierDependency(managerServiceName);
        ServiceName listenerServiceName = name.append(new String[]{"listener"});
        SessionListenerServiceConfigurator listenerConfigurator = new SessionListenerServiceConfigurator(listenerServiceName, (SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>>)managerDependency);
        ServiceSupplierDependency listenerDependency = new ServiceSupplierDependency(listenerServiceName);
        ServiceName registryServiceName = name.append(new String[]{"registry"});
        SessionManagerRegistryServiceConfigurator registryConfigurator = new SessionManagerRegistryServiceConfigurator(registryServiceName, serverName, hostName, (SupplierDependency<SessionListener>)listenerDependency);
        this.manager = new ServiceSupplierDependency(managerConfigurator);
        this.registry = new ServiceSupplierDependency((ServiceNameProvider)registryConfigurator);
        this.configurators = Arrays.asList(new CapabilityServiceConfigurator[]{factoryConfigurator, generatorConfigurator, managerConfigurator, listenerConfigurator, registryConfigurator});
    }

    @Override
    public SingleSignOnManager get() {
        return new DistributableSingleSignOnManager((SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>)((SSOManager)this.manager.get()), (SessionManagerRegistry)this.registry.get());
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        for (CapabilityServiceConfigurator configurator : this.configurators) {
            configurator.configure(support);
        }
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        for (CapabilityServiceConfigurator configurator : this.configurators) {
            configurator.build(target).install();
        }
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer manager = new CompositeDependency(new Dependency[]{this.manager, this.registry}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(manager, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }
}

