/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;

public class NoOpFuture<E>
implements NotifyingNotifiableFuture<E> {
    private final E returnValue;
    private final Throwable t;

    public NoOpFuture(E returnValue) {
        this.returnValue = returnValue;
        this.t = null;
    }

    public NoOpFuture(Throwable t) {
        this.returnValue = null;
        this.t = t;
    }

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public E get() throws InterruptedException, ExecutionException {
        if (this.t != null) {
            throw new ExecutionException(this.t);
        }
        return this.returnValue;
    }

    @Override
    public E get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    @Override
    public void notifyDone(E result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyException(Throwable exception) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFuture(Future<E> eFuture) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NotifyingFuture<E> attachListener(FutureListener<E> eFutureListener) {
        eFutureListener.futureDone(this);
        return this;
    }
}

