/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.util.HashMap;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

@Command(name="mask", description="mask a password and print it out")
public class Mask
implements Action {
    @Arguments(description="The password to be masked", required=true)
    String password;
    @Option(name={"--hash"}, description="whether to use hash (one-way), default false")
    boolean hash = false;
    @Option(name={"--key"}, description="the key (Blowfish) to mask a password")
    String key;
    private DefaultSensitiveStringCodec codec;

    @Override
    public Object execute(ActionContext context) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.hash) {
            params.put("algorithm", "one-way");
        }
        if (this.key != null) {
            if (this.hash) {
                context.out.println("Option --key ignored in case of hashing");
            } else {
                params.put("key", this.key);
            }
        }
        this.codec = PasswordMaskingUtil.getDefaultCodec();
        this.codec.init(params);
        String masked = this.codec.encode((Object)this.password);
        context.out.println("result: " + masked);
        return masked;
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    @Override
    public void setHomeValues(File brokerHome, File brokerInstance) {
    }

    @Override
    public String getBrokerInstance() {
        return null;
    }

    @Override
    public String getBrokerHome() {
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHash(boolean hash) {
        this.hash = hash;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DefaultSensitiveStringCodec getCodec() {
        return this.codec;
    }
}

