/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.AddressQueryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditsImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CommandConfirmationHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQConsumerContext;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerWithKillMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.utils.TokenBucketLimiterImpl;
import org.jboss.logging.Logger;

public class ActiveMQSessionContext
extends SessionContext {
    private static final Logger logger = Logger.getLogger(ActiveMQSessionContext.class);
    private final Channel sessionChannel;
    private final int serverVersion;
    private int confirmationWindow;
    private String name;
    private boolean killed;
    private final CommandConfirmationHandler confirmationHandler = new CommandConfirmationHandler(){

        @Override
        public void commandConfirmed(Packet packet) {
            SessionSendContinuationMessage scm;
            if (packet.getType() == 71) {
                SessionSendMessage ssm = (SessionSendMessage)packet;
                this.callSendAck(ssm.getHandler(), ssm.getMessage());
            } else if (packet.getType() == 73 && !(scm = (SessionSendContinuationMessage)packet).isContinues()) {
                this.callSendAck(scm.getHandler(), scm.getMessage());
            }
        }

        private void callSendAck(SendAcknowledgementHandler handler, Message message) {
            if (handler != null) {
                handler.sendAcknowledged(message);
            } else if (ActiveMQSessionContext.this.sendAckHandler != null) {
                ActiveMQSessionContext.this.sendAckHandler.sendAcknowledged(message);
            }
        }
    };

    protected Channel getSessionChannel() {
        return this.sessionChannel;
    }

    protected String getName() {
        return this.name;
    }

    @Override
    public void resetName(String name) {
        this.name = name;
    }

    protected int getConfirmationWindow() {
        return this.confirmationWindow;
    }

    public ActiveMQSessionContext(String name, RemotingConnection remotingConnection, Channel sessionChannel, int serverVersion, int confirmationWindow) {
        super(remotingConnection);
        this.name = name;
        this.sessionChannel = sessionChannel;
        this.serverVersion = serverVersion;
        this.confirmationWindow = confirmationWindow;
        ClientSessionPacketHandler handler = new ClientSessionPacketHandler();
        sessionChannel.setHandler(handler);
        if (confirmationWindow >= 0) {
            sessionChannel.setCommandConfirmationHandler(this.confirmationHandler);
        }
    }

    @Override
    public int getReconnectID() {
        return this.sessionChannel.getReconnectID();
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void kill() {
        this.killed = true;
    }

    @Override
    public void returnBlocking(ActiveMQException cause) {
        this.sessionChannel.returnBlocking(cause);
    }

    @Override
    public void lockCommunications() {
        this.sessionChannel.lock();
    }

    @Override
    public void releaseCommunications() {
        this.sessionChannel.setTransferring(false);
        this.sessionChannel.unlock();
    }

    @Override
    public void cleanup() {
        this.sessionChannel.close();
        this.sessionChannel.returnBlocking();
    }

    @Override
    public void linkFlowControl(SimpleString address, ClientProducerCreditsImpl clientProducerCredits) {
    }

    @Override
    public void setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.sessionChannel.setCommandConfirmationHandler(this.confirmationHandler);
        this.sendAckHandler = handler;
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new CreateSharedQueueMessage(address, queueName, filterString, durable, true), (byte)21);
    }

    @Override
    public void deleteQueue(SimpleString queueName) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new SessionDeleteQueueMessage(queueName), (byte)21);
    }

    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws ActiveMQException {
        SessionQueueQueryMessage request = new SessionQueueQueryMessage(queueName);
        SessionQueueQueryResponseMessage_V2 response = (SessionQueueQueryResponseMessage_V2)this.sessionChannel.sendBlocking(request, (byte)-7);
        return response.toQueueQuery();
    }

    @Override
    public boolean isWritable(ReadyListener callback) {
        return this.remotingConnection.isWritable(callback);
    }

    @Override
    public ClientConsumerInternal createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, int ackBatchSize, boolean browseOnly, Executor executor, Executor flowControlExecutor) throws ActiveMQException {
        long consumerID = this.idGenerator.generateID();
        ActiveMQConsumerContext consumerContext = new ActiveMQConsumerContext(consumerID);
        SessionCreateConsumerMessage request = new SessionCreateConsumerMessage(consumerID, queueName, filterString, browseOnly, true);
        SessionQueueQueryResponseMessage_V2 queueInfo = (SessionQueueQueryResponseMessage_V2)this.sessionChannel.sendBlocking(request, (byte)-7);
        return new ClientConsumerImpl(this.session, consumerContext, queueName, filterString, browseOnly, this.calcWindowSize(windowSize), ackBatchSize, maxRate > 0 ? new TokenBucketLimiterImpl(maxRate, false) : null, executor, flowControlExecutor, this, queueInfo.toQueueQuery(), this.lookupTCCL());
    }

    @Override
    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws ActiveMQException {
        if (this.sessionChannel.supports((byte)-10, this.getServerVersion())) {
            Packet packet = this.sessionChannel.sendBlocking(new SessionBindingQueryMessage(address), (byte)-10);
            SessionBindingQueryResponseMessage_V3 response = (SessionBindingQueryResponseMessage_V3)packet;
            return new AddressQueryImpl(response.isExists(), response.getQueueNames(), response.isAutoCreateJmsQueues(), response.isAutoCreateJmsTopics());
        }
        if (this.sessionChannel.supports((byte)-8, this.getServerVersion())) {
            Packet packet = this.sessionChannel.sendBlocking(new SessionBindingQueryMessage(address), (byte)-8);
            SessionBindingQueryResponseMessage_V2 response = (SessionBindingQueryResponseMessage_V2)packet;
            return new AddressQueryImpl(response.isExists(), response.getQueueNames(), response.isAutoCreateJmsQueues(), false);
        }
        Packet packet = this.sessionChannel.sendBlocking(new SessionBindingQueryMessage(address), (byte)50);
        SessionBindingQueryResponseMessage response = (SessionBindingQueryResponseMessage)packet;
        return new AddressQueryImpl(response.isExists(), response.getQueueNames(), false, false);
    }

    @Override
    public void closeConsumer(ClientConsumer consumer) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new SessionConsumerCloseMessage(this.getConsumerID(consumer)), (byte)21);
    }

    @Override
    public void sendConsumerCredits(ClientConsumer consumer, int credits) {
        this.sessionChannel.send(new SessionConsumerFlowCreditMessage(this.getConsumerID(consumer), credits));
    }

    @Override
    public void forceDelivery(ClientConsumer consumer, long sequence) throws ActiveMQException {
        SessionForceConsumerDelivery request = new SessionForceConsumerDelivery(this.getConsumerID(consumer), sequence);
        this.sessionChannel.send(request);
    }

    @Override
    public void simpleCommit() throws ActiveMQException {
        this.sessionChannel.sendBlocking(new PacketImpl(43), (byte)21);
    }

    @Override
    public void simpleRollback(boolean lastMessageAsDelivered) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new RollbackMessage(lastMessageAsDelivered), (byte)21);
    }

    @Override
    public void sessionStart() throws ActiveMQException {
        this.sessionChannel.send(new PacketImpl(67));
    }

    @Override
    public void sessionStop() throws ActiveMQException {
        this.sessionChannel.sendBlocking(new PacketImpl(68), (byte)21);
    }

    @Override
    public void addSessionMetadata(String key, String data) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new SessionAddMetaDataMessageV2(key, data), (byte)21);
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws ActiveMQException {
        this.sessionChannel.sendBlocking(new SessionUniqueAddMetaDataMessage(key, data), (byte)21);
    }

    @Override
    public void xaCommit(Xid xid, boolean onePhase) throws XAException, ActiveMQException {
        SessionXACommitMessage packet = new SessionXACommitMessage(xid, onePhase);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("finished commit on " + ClientSessionImpl.convert(xid) + " with response = " + response);
        }
    }

    @Override
    public void xaEnd(Xid xid, int flags) throws XAException, ActiveMQException {
        PacketImpl packet;
        if (flags == 0x2000000) {
            packet = new PacketImpl(58);
        } else if (flags == 0x4000000) {
            packet = new SessionXAEndMessage(xid, false);
        } else if (flags == 0x20000000) {
            packet = new SessionXAEndMessage(xid, true);
        } else {
            throw new XAException(-5);
        }
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.sessionChannel.send(new SessionRequestProducerCreditsMessage(credits, address));
    }

    @Override
    public boolean supportsLargeMessage() {
        return true;
    }

    @Override
    public int getCreditsOnSendingFull(MessageInternal msgI) {
        return msgI.getEncodeSize();
    }

    @Override
    public void sendFullMessage(MessageInternal msgI, boolean sendBlocking, SendAcknowledgementHandler handler, SimpleString defaultAddress) throws ActiveMQException {
        SessionSendMessage packet = new SessionSendMessage(msgI, sendBlocking, handler);
        if (sendBlocking) {
            this.sessionChannel.sendBlocking(packet, (byte)21);
        } else {
            this.sessionChannel.sendBatched(packet);
        }
    }

    @Override
    public int sendInitialChunkOnLargeMessage(MessageInternal msgI) throws ActiveMQException {
        SessionSendLargeMessage initialChunk = new SessionSendLargeMessage(msgI);
        this.sessionChannel.send(initialChunk);
        return msgI.getHeadersAndPropertiesEncodeSize();
    }

    @Override
    public int sendLargeMessageChunk(MessageInternal msgI, long messageBodySize, boolean sendBlocking, boolean lastChunk, byte[] chunk, int reconnectID, SendAcknowledgementHandler messageHandler) throws ActiveMQException {
        return ActiveMQSessionContext.sendSessionSendContinuationMessage(this.sessionChannel, msgI, messageBodySize, sendBlocking, lastChunk, chunk, messageHandler);
    }

    @Override
    public int sendServerLargeMessageChunk(MessageInternal msgI, long messageBodySize, boolean sendBlocking, boolean lastChunk, byte[] chunk, SendAcknowledgementHandler messageHandler) throws ActiveMQException {
        return ActiveMQSessionContext.sendSessionSendContinuationMessage(this.sessionChannel, msgI, messageBodySize, sendBlocking, lastChunk, chunk, messageHandler);
    }

    @Override
    public void sendACK(boolean individual, boolean block, ClientConsumer consumer, Message message) throws ActiveMQException {
        PacketImpl messagePacket = individual ? new SessionIndividualAcknowledgeMessage(this.getConsumerID(consumer), message.getMessageID(), block) : new SessionAcknowledgeMessage(this.getConsumerID(consumer), message.getMessageID(), block);
        if (block) {
            this.sessionChannel.sendBlocking(messagePacket, (byte)21);
        } else {
            this.sessionChannel.sendBatched(messagePacket);
        }
    }

    @Override
    public void expireMessage(ClientConsumer consumer, Message message) throws ActiveMQException {
        SessionExpireMessage messagePacket = new SessionExpireMessage(this.getConsumerID(consumer), message.getMessageID());
        this.sessionChannel.send(messagePacket);
    }

    @Override
    public void sessionClose() throws ActiveMQException {
        this.sessionChannel.sendBlocking(new SessionCloseMessage(), (byte)21);
    }

    @Override
    public void xaForget(Xid xid) throws XAException, ActiveMQException {
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(new SessionXAForgetMessage(xid), (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public int xaPrepare(Xid xid) throws XAException, ActiveMQException {
        SessionXAPrepareMessage packet = new SessionXAPrepareMessage(xid);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
        return response.getResponseCode();
    }

    @Override
    public Xid[] xaScan() throws ActiveMQException {
        SessionXAGetInDoubtXidsResponseMessage response = (SessionXAGetInDoubtXidsResponseMessage)this.sessionChannel.sendBlocking(new PacketImpl(61), (byte)62);
        List<Xid> xids = response.getXids();
        Xid[] xidArray = xids.toArray(new Xid[xids.size()]);
        return xidArray;
    }

    @Override
    public void xaRollback(Xid xid, boolean wasStarted) throws ActiveMQException, XAException {
        SessionXARollbackMessage packet = new SessionXARollbackMessage(xid);
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public void xaStart(Xid xid, int flags) throws XAException, ActiveMQException {
        PacketImpl packet;
        if (flags == 0x200000) {
            packet = new SessionXAJoinMessage(xid);
        } else if (flags == 0x8000000) {
            packet = new SessionXAResumeMessage(xid);
        } else if (flags == 0) {
            packet = new SessionXAStartMessage(xid);
        } else {
            throw new XAException(-5);
        }
        SessionXAResponseMessage response = (SessionXAResponseMessage)this.sessionChannel.sendBlocking(packet, (byte)55);
        if (response.isError()) {
            ActiveMQClientLogger.LOGGER.errorCallingStart(response.getMessage(), response.getResponseCode());
            throw new XAException(response.getResponseCode());
        }
    }

    @Override
    public boolean configureTransactionTimeout(int seconds) throws ActiveMQException {
        SessionXASetTimeoutResponseMessage response = (SessionXASetTimeoutResponseMessage)this.sessionChannel.sendBlocking(new SessionXASetTimeoutMessage(seconds), (byte)64);
        return response.isOK();
    }

    @Override
    public int recoverSessionTimeout() throws ActiveMQException {
        SessionXAGetTimeoutResponseMessage response = (SessionXAGetTimeoutResponseMessage)this.sessionChannel.sendBlocking(new PacketImpl(65), (byte)66);
        return response.getTimeoutSeconds();
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temp) throws ActiveMQException {
        CreateQueueMessage request = new CreateQueueMessage(address, queueName, filterString, durable, temp, true);
        this.sessionChannel.sendBlocking(request, (byte)21);
    }

    @Override
    public boolean reattachOnNewConnection(RemotingConnection newConnection) throws ActiveMQException {
        this.remotingConnection = newConnection;
        this.sessionChannel.transferConnection((CoreRemotingConnection)newConnection);
        ReattachSessionMessage request = new ReattachSessionMessage(this.name, this.sessionChannel.getLastConfirmedCommandID());
        Channel channel1 = this.getCoreConnection().getChannel(1L, -1);
        ReattachSessionResponseMessage response = (ReattachSessionResponseMessage)channel1.sendBlocking(request, (byte)33);
        if (response.isReattached()) {
            ActiveMQClientLogger.LOGGER.replayingCommands(this.sessionChannel.getID(), response.getLastConfirmedCommandID());
            this.sessionChannel.replayCommands(response.getLastConfirmedCommandID());
            return true;
        }
        ActiveMQClientLogger.LOGGER.reconnectCreatingNewSession(this.sessionChannel.getID());
        this.sessionChannel.clearCommands();
        return false;
    }

    @Override
    public void recreateSession(String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws ActiveMQException {
        boolean retry;
        CreateSessionMessage createRequest = this.newCreateSession(username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge);
        do {
            try {
                this.getCreateChannel().sendBlocking(createRequest, (byte)31);
                retry = false;
            }
            catch (ActiveMQException e) {
                if (e.getType() == ActiveMQExceptionType.SESSION_CREATION_REJECTED) {
                    ActiveMQClientLogger.LOGGER.retryCreateSessionSeverStarting(this.name);
                    retry = true;
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                throw e;
            }
        } while (retry && !this.session.isClosing());
    }

    protected CreateSessionMessage newCreateSession(String username, String password, int minLargeMessageSize, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) {
        return new CreateSessionMessage(this.name, this.sessionChannel.getID(), this.serverVersion, username, password, minLargeMessageSize, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.confirmationWindow, null);
    }

    @Override
    public void recreateConsumerOnServer(ClientConsumerInternal consumerInternal) throws ActiveMQException {
        ClientSession.QueueQuery queueInfo = consumerInternal.getQueueInfo();
        if (!queueInfo.isDurable()) {
            CreateQueueMessage createQueueRequest = new CreateQueueMessage(queueInfo.getAddress(), queueInfo.getName(), queueInfo.getFilterString(), false, queueInfo.isTemporary(), false);
            this.sendPacketWithoutLock(this.sessionChannel, createQueueRequest);
        }
        SessionCreateConsumerMessage createConsumerRequest = new SessionCreateConsumerMessage(this.getConsumerID(consumerInternal), consumerInternal.getQueueName(), consumerInternal.getFilterString(), consumerInternal.isBrowseOnly(), false);
        this.sendPacketWithoutLock(this.sessionChannel, createConsumerRequest);
        int clientWindowSize = consumerInternal.getClientWindowSize();
        if (clientWindowSize != 0) {
            SessionConsumerFlowCreditMessage packet = new SessionConsumerFlowCreditMessage(this.getConsumerID(consumerInternal), clientWindowSize);
            this.sendPacketWithoutLock(this.sessionChannel, packet);
        } else {
            SessionConsumerFlowCreditMessage packet = new SessionConsumerFlowCreditMessage(this.getConsumerID(consumerInternal), 1);
            this.sendPacketWithoutLock(this.sessionChannel, packet);
        }
    }

    @Override
    public void xaFailed(Xid xid) throws ActiveMQException {
        this.sendPacketWithoutLock(this.sessionChannel, new SessionXAAfterFailedMessage(xid));
    }

    @Override
    public void restartSession() throws ActiveMQException {
        this.sendPacketWithoutLock(this.sessionChannel, new PacketImpl(67));
    }

    @Override
    public void resetMetadata(HashMap<String, String> metaDataToSend) {
        for (Map.Entry<String, String> entries : metaDataToSend.entrySet()) {
            this.sendPacketWithoutLock(this.sessionChannel, new SessionAddMetaDataMessageV2(entries.getKey(), entries.getValue(), false));
        }
    }

    private Channel getCreateChannel() {
        return this.getCoreConnection().getChannel(1L, -1);
    }

    private CoreRemotingConnection getCoreConnection() {
        return (CoreRemotingConnection)this.remotingConnection;
    }

    private void handleConsumerDisconnected(DisconnectConsumerMessage packet) throws ActiveMQException {
        DisconnectConsumerMessage message = packet;
        this.session.handleConsumerDisconnect(new ActiveMQConsumerContext(message.getConsumerId()));
    }

    private void handleReceivedMessagePacket(SessionReceiveMessage messagePacket) throws Exception {
        ClientMessageInternal msgi = (ClientMessageInternal)messagePacket.getMessage();
        msgi.setDeliveryCount(messagePacket.getDeliveryCount());
        msgi.setFlowControlSize(messagePacket.getPacketSize());
        this.handleReceiveMessage(new ActiveMQConsumerContext(messagePacket.getConsumerID()), msgi);
    }

    private void handleReceiveLargeMessage(SessionReceiveLargeMessage serverPacket) throws Exception {
        ClientLargeMessageInternal clientLargeMessage = (ClientLargeMessageInternal)((Object)serverPacket.getLargeMessage());
        clientLargeMessage.setFlowControlSize(serverPacket.getPacketSize());
        clientLargeMessage.setDeliveryCount(serverPacket.getDeliveryCount());
        this.handleReceiveLargeMessage(new ActiveMQConsumerContext(serverPacket.getConsumerID()), clientLargeMessage, serverPacket.getLargeMessageSize());
    }

    private void handleReceiveContinuation(SessionReceiveContinuationMessage continuationPacket) throws Exception {
        this.handleReceiveContinuation(new ActiveMQConsumerContext(continuationPacket.getConsumerID()), continuationPacket.getBody(), continuationPacket.getPacketSize(), continuationPacket.isContinues());
    }

    protected void handleReceiveProducerCredits(SessionProducerCreditsMessage message) {
        this.handleReceiveProducerCredits(message.getAddress(), message.getCredits());
    }

    protected void handleReceiveProducerFailCredits(SessionProducerCreditsFailMessage message) {
        this.handleReceiveProducerFailCredits(message.getAddress(), message.getCredits());
    }

    protected void handleReceiveSlowConsumerKillMessage(DisconnectConsumerWithKillMessage message) {
        if (message.getNodeID() != null) {
            this.kill();
        }
    }

    private static int sendSessionSendContinuationMessage(Channel channel, MessageInternal msgI, long messageBodySize, boolean sendBlocking, boolean lastChunk, byte[] chunk, SendAcknowledgementHandler messageHandler) throws ActiveMQException {
        boolean requiresResponse = lastChunk && sendBlocking;
        SessionSendContinuationMessage chunkPacket = new SessionSendContinuationMessage(msgI, chunk, !lastChunk, requiresResponse, messageBodySize, messageHandler);
        int expectedEncodeSize = chunkPacket.expectedEncodeSize();
        CoreRemotingConnection connection = channel.getConnection();
        long blockingCallTimeoutMillis = Math.max(0L, connection.getBlockingCallTimeout());
        long startFlowControl = System.nanoTime();
        try {
            boolean isWritable = connection.blockUntilWritable(expectedEncodeSize, blockingCallTimeoutMillis);
            if (!isWritable) {
                long endFlowControl = System.nanoTime();
                long elapsedFlowControl = endFlowControl - startFlowControl;
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsedFlowControl);
                ActiveMQClientLogger.LOGGER.timeoutStreamingLargeMessage();
                logger.debug("try to write " + expectedEncodeSize + " bytes after blocked " + elapsedMillis + " ms on a not writable connection: [" + connection.getID() + "]");
            }
            if (requiresResponse) {
                channel.sendBlocking(chunkPacket, (byte)21);
            } else {
                channel.send(chunkPacket);
            }
            return chunkPacket.getPacketSize();
        }
        catch (Throwable e) {
            throw new ActiveMQException(e.getMessage());
        }
    }

    private long getConsumerID(ClientConsumer consumer) {
        return ((ActiveMQConsumerContext)consumer.getConsumerContext()).getId();
    }

    protected ClassLoader lookupTCCL() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected int calcWindowSize(int windowSize) {
        int clientWindowSize;
        if (windowSize == -1) {
            clientWindowSize = -1;
        } else if (windowSize == 0) {
            clientWindowSize = 0;
        } else if (windowSize == 1) {
            clientWindowSize = 1;
        } else if (windowSize > 1) {
            clientWindowSize = windowSize >> 1;
        } else {
            throw ActiveMQClientMessageBundle.BUNDLE.invalidWindowSize(windowSize);
        }
        return clientWindowSize;
    }

    private void sendPacketWithoutLock(Channel parameterChannel, Packet packet) {
        packet.setChannelID(parameterChannel.getID());
        Connection conn = parameterChannel.getConnection().getTransportConnection();
        ActiveMQBuffer buffer = packet.encode(this.getCoreConnection());
        conn.write(buffer, false, false);
    }

    class ClientSessionPacketHandler
    implements ChannelHandler {
        ClientSessionPacketHandler() {
        }

        @Override
        public void handlePacket(Packet packet) {
            byte type = packet.getType();
            try {
                switch (type) {
                    case 12: {
                        ActiveMQSessionContext.this.handleConsumerDisconnected((DisconnectConsumerMessage)packet);
                        break;
                    }
                    case 77: {
                        ActiveMQSessionContext.this.handleReceiveContinuation((SessionReceiveContinuationMessage)packet);
                        break;
                    }
                    case 75: {
                        ActiveMQSessionContext.this.handleReceivedMessagePacket((SessionReceiveMessage)packet);
                        break;
                    }
                    case 76: {
                        ActiveMQSessionContext.this.handleReceiveLargeMessage((SessionReceiveLargeMessage)packet);
                        break;
                    }
                    case 80: {
                        ActiveMQSessionContext.this.handleReceiveProducerCredits((SessionProducerCreditsMessage)packet);
                        break;
                    }
                    case 82: {
                        ActiveMQSessionContext.this.handleReceiveProducerFailCredits((SessionProducerCreditsFailMessage)packet);
                        break;
                    }
                    case 13: {
                        ActiveMQSessionContext.this.handleReceiveSlowConsumerKillMessage((DisconnectConsumerWithKillMessage)packet);
                        break;
                    }
                    case 20: {
                        ActiveMQExceptionMessage mem = (ActiveMQExceptionMessage)packet;
                        ActiveMQClientLogger.LOGGER.receivedExceptionAsynchronously(mem.getException());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid packet: " + type);
                    }
                }
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.failedToHandlePacket(e);
            }
            ActiveMQSessionContext.this.sessionChannel.confirm(packet);
        }
    }
}

