/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.stream.JsonGrammarAnalyzer;
import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelWriter;
import org.jboss.dmr.stream.Utils;

final class JsonWriterImpl
implements ModelWriter {
    private final JsonGrammarAnalyzer analyzer;
    private final Writer out;
    private final char[] buffer = new char[1024];
    private int limit;
    private boolean closed;

    JsonWriterImpl(Writer out) {
        this.out = out;
        this.analyzer = new JsonGrammarAnalyzer();
    }

    @Override
    public void close() throws IOException, ModelException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        if (!this.analyzer.finished) {
            throw this.analyzer.newModelException("Uncomplete DMR stream have been written");
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.out.flush();
    }

    @Override
    public ModelWriter writeObjectStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putObjectStart();
        this.write('{');
        return this;
    }

    @Override
    public ModelWriter writeObjectEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putObjectEnd();
        this.write('}');
        return this;
    }

    @Override
    public ModelWriter writeListStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putListStart();
        this.write('[');
        return this;
    }

    @Override
    public ModelWriter writeListEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putListEnd();
        this.write(']');
        return this;
    }

    @Override
    public ModelWriter writePropertyStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putPropertyStart();
        this.write('{');
        return this;
    }

    @Override
    public ModelWriter writePropertyEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putPropertyEnd();
        this.write('}');
        return this;
    }

    @Override
    public ModelWriter writeExpression(String data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putExpression();
        this.write('{');
        this.encode("EXPRESSION_VALUE");
        this.write(':');
        this.encode(data);
        this.write('}');
        return this;
    }

    @Override
    public ModelWriter writeBytes(byte[] data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putBytes();
        this.write('{');
        this.encode("BYTES_VALUE");
        this.write(':');
        this.base64Encode(data);
        this.write('}');
        return this;
    }

    @Override
    public ModelWriter writeType(ModelType data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter((Object)data);
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putType();
        this.write('{');
        this.write('\"');
        this.write("TYPE_MODEL_VALUE");
        this.write('\"');
        this.write(':');
        this.write('\"');
        this.write(data.toString());
        this.write('\"');
        this.write('}');
        return this;
    }

    @Override
    public ModelWriter writeString(String data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putString();
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriter writeUndefined() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putUndefined();
        this.write("null", 0, "null".length());
        return this;
    }

    @Override
    public ModelWriter writeBoolean(boolean data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putBoolean();
        if (data) {
            this.write("true");
        } else {
            this.write("false");
        }
        return this;
    }

    @Override
    public ModelWriter writeInt(int data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber(ModelEvent.INT);
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriter writeLong(long data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber(ModelEvent.LONG);
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriter writeDouble(double data) throws IOException, ModelException {
        return this.writeNumber(String.valueOf(data), ModelEvent.DOUBLE);
    }

    @Override
    public ModelWriter writeBigInteger(BigInteger data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter(data);
        return this.writeNumber(String.valueOf(data), ModelEvent.BIG_INTEGER);
    }

    @Override
    public ModelWriter writeBigDecimal(BigDecimal data) throws IOException, ModelException {
        JsonWriterImpl.assertNotNullParameter(data);
        return this.writeNumber(String.valueOf(data), ModelEvent.BIG_DECIMAL);
    }

    private ModelWriter writeNumber(String data, ModelEvent numberEvent) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalColonOrComma();
        this.analyzer.putNumber(numberEvent);
        this.write(data, 0, data.length());
        return this;
    }

    private void writeOptionalColonOrComma() throws IOException, ModelException {
        if (this.analyzer.isColonExpected()) {
            this.analyzer.putColon();
            this.write(':');
        } else if (this.analyzer.isCommaExpected()) {
            this.analyzer.putComma();
            this.write(',');
        }
    }

    private void write(String data) throws IOException {
        this.write(data, 0, data.length());
    }

    private void write(char c) throws IOException {
        if (this.limit == this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.buffer[this.limit++] = c;
    }

    private void write(String data, int dataBegin, int dataEnd) throws IOException {
        while (dataBegin < dataEnd) {
            int count = Math.min(dataEnd - dataBegin, this.buffer.length - this.limit);
            data.getChars(dataBegin, dataBegin + count, this.buffer, this.limit);
            dataBegin += count;
            this.limit += count;
            if (this.limit != this.buffer.length) continue;
            this.out.write(this.buffer, 0, this.buffer.length);
            this.limit = 0;
        }
    }

    private void encode(String s) throws IOException {
        this.write('\"');
        int dataBegin = 0;
        for (int dataEnd = 0; dataEnd < s.length(); ++dataEnd) {
            char c = s.charAt(dataEnd);
            while (c != '\\' && c != '\"' && !Utils.isControl(c) && ++dataEnd < s.length()) {
                c = s.charAt(dataEnd);
            }
            if (dataBegin < dataEnd) {
                this.write(s, dataBegin, dataEnd);
                if (dataEnd == s.length()) break;
            }
            dataBegin = dataEnd + 1;
            this.write('\\');
            if (c == '\\' || c == '\"') {
                this.write(c);
                continue;
            }
            if (c == '\b') {
                this.write('b');
                continue;
            }
            if (c == '\f') {
                this.write('f');
                continue;
            }
            if (c == '\n') {
                this.write('n');
                continue;
            }
            if (c == '\r') {
                this.write('r');
                continue;
            }
            if (c == '\t') {
                this.write('t');
                continue;
            }
            this.write('u');
            String hexString = Integer.toHexString(c);
            for (int j = 0; j < 4 - hexString.length(); ++j) {
                this.write('0');
            }
            this.write(hexString, 0, hexString.length());
        }
        this.write('\"');
    }

    private void base64Encode(byte[] data) throws IOException {
        this.write('\"');
        for (int i = 0; i < data.length; i += 3) {
            if (this.buffer.length - this.limit < 4) {
                this.out.write(this.buffer, 0, this.limit);
                this.limit = 0;
            }
            if (i > 0 && i % 57 == 0) {
                System.arraycopy(Utils.BASE64_NEWLINE, 0, this.buffer, this.limit, 4);
                this.limit += 4;
                continue;
            }
            int b = (data[i] & 0xFC) >> 2;
            this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b];
            b = (data[i] & 3) << 4;
            if (i + 1 < data.length) {
                this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b |= (data[i + 1] & 0xF0) >> 4];
                b = (data[i + 1] & 0xF) << 2;
                if (i + 2 < data.length) {
                    this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b |= (data[i + 2] & 0xC0) >> 6];
                    b = data[i + 2] & 0x3F;
                    this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b];
                    continue;
                }
                this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b];
                this.buffer[this.limit++] = 61;
                continue;
            }
            this.buffer[this.limit++] = Utils.BASE64_ENC_TABLE[b];
            this.buffer[this.limit++] = 61;
            this.buffer[this.limit++] = 61;
        }
        this.write('\"');
    }

    private void encode(long l) throws IOException {
        int intQuotient;
        int remainder;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 20) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(l);
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        while (l < Integer.MIN_VALUE) {
            long longQuotient = l / 100L;
            remainder = (int)(longQuotient * 100L - l);
            l = longQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        int i = (int)l;
        while (i <= -100) {
            intQuotient = i / 100;
            remainder = intQuotient * 100 - i;
            i = intQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        intQuotient = i / 10;
        remainder = intQuotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (intQuotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - intQuotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void encode(int i) throws IOException {
        int remainder;
        int quotient;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 11) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(i);
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            quotient = i / 100;
            remainder = quotient * 100 - i;
            i = quotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        quotient = i / 10;
        remainder = quotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (quotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - quotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("DMR writer have been closed");
        }
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

