/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Deprecated
public class ExternalManagementRequestExecutor
implements Service<ExecutorService> {
    @Deprecated
    public static final ServiceName SERVICE_NAME = Services.JBOSS_AS.append(new String[]{"external-mgmt-executor"});
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int WORK_QUEUE_SIZE = 512;
    private static final String POOL_SIZE_PROP = "org.wildfly.unsupported.external.management.pool-size";
    private final InjectedValue<ExecutorService> injectedExecutor = new InjectedValue();
    private final ThreadGroup threadGroup;
    private ExecutorService executorService;

    private static int getPoolSize() {
        int defaultThreads = 10;
        String maxThreads = WildFlySecurityManager.getPropertyPrivileged((String)POOL_SIZE_PROP, null);
        if (maxThreads != null && maxThreads.length() > 0) {
            try {
                int max = Integer.decode(maxThreads);
                defaultThreads = Math.max(max, 1);
            }
            catch (NumberFormatException ex) {
                ServerLogger.ROOT_LOGGER.failedToParseCommandLineInteger(POOL_SIZE_PROP, maxThreads);
            }
        }
        return defaultThreads;
    }

    public static void install(ServiceTarget target, ThreadGroup threadGroup, ServiceName cleanupExecutor) {
        ExternalManagementRequestExecutor service = new ExternalManagementRequestExecutor(threadGroup);
        target.addService(SERVICE_NAME, (Service)service).addDependency(cleanupExecutor, ExecutorService.class, service.injectedExecutor).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    private ExternalManagementRequestExecutor(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public synchronized void start(StartContext context) throws StartException {
        String namePattern = "External Management Request Threads -- %t";
        ThreadFactory threadFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(ExternalManagementRequestExecutor.this.threadGroup, Boolean.FALSE, null, "External Management Request Threads -- %t", null, null);
            }
        });
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(512);
        int poolSize = ExternalManagementRequestExecutor.getPoolSize();
        this.executorService = new ThreadPoolExecutor(poolSize, poolSize, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        if (this.executorService != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ExternalManagementRequestExecutor.this.executorService.shutdown();
                    }
                    finally {
                        ExternalManagementRequestExecutor.this.executorService = null;
                        context.complete();
                    }
                }
            };
            ExecutorService executorService = (ExecutorService)this.injectedExecutor.getValue();
            try {
                try {
                    executorService.execute(r);
                }
                catch (RejectedExecutionException e) {
                    r.run();
                }
            }
            finally {
                context.asynchronous();
            }
        }
    }

    public synchronized ExecutorService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.executorService;
    }
}

