/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.WeldModuleResourceLoader;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.ProxyServicesImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldDeployment
implements CDI11Deployment {
    public static final String ADDITIONAL_CLASSES_BDA_SUFFIX = ".additionalClasses";
    public static final String BOOTSTRAP_CLASSLOADER_BDA_ID = "bootstrapBDA.additionalClasses";
    private final Set<BeanDeploymentArchiveImpl> beanDeploymentArchives;
    private final Set<Metadata<Extension>> extensions;
    private final ServiceRegistry serviceRegistry;
    private final Module module;
    private final Set<ClassLoader> subDeploymentClassLoaders;
    private final Map<ClassLoader, BeanDeploymentArchiveImpl> additionalBeanDeploymentArchivesByClassloader;
    private volatile BeanDeploymentArchiveImpl bootstrapClassLoaderBeanDeploymentArchive;
    private final BeanDeploymentModule rootBeanDeploymentModule;
    private final Map<ModuleIdentifier, EEModuleDescriptor> eeModuleDescriptors;

    public WeldDeployment(Set<BeanDeploymentArchiveImpl> beanDeploymentArchives, Collection<Metadata<Extension>> extensions, Module module, Set<ClassLoader> subDeploymentClassLoaders, DeploymentUnit deploymentUnit, BeanDeploymentModule rootBeanDeploymentModule, Map<ModuleIdentifier, EEModuleDescriptor> eeModuleDescriptors) {
        this.subDeploymentClassLoaders = new HashSet<ClassLoader>(subDeploymentClassLoaders);
        this.beanDeploymentArchives = Collections.newSetFromMap(new ConcurrentHashMap());
        this.beanDeploymentArchives.addAll(beanDeploymentArchives);
        this.extensions = new HashSet<Metadata<Extension>>(extensions);
        this.serviceRegistry = new SimpleServiceRegistry();
        this.additionalBeanDeploymentArchivesByClassloader = new ConcurrentHashMap<ClassLoader, BeanDeploymentArchiveImpl>();
        this.module = module;
        this.rootBeanDeploymentModule = rootBeanDeploymentModule;
        this.eeModuleDescriptors = eeModuleDescriptors;
        this.serviceRegistry.add(ProxyServices.class, (Service)new ProxyServicesImpl(module));
        this.serviceRegistry.add(ResourceLoader.class, (Service)new WeldModuleResourceLoader(module));
        this.calculateAccessibilityGraph(this.beanDeploymentArchives);
        this.makeTopLevelBdasVisibleFromStaticModules();
    }

    private void calculateAccessibilityGraph(Iterable<BeanDeploymentArchiveImpl> beanDeploymentArchives) {
        for (BeanDeploymentArchiveImpl from : beanDeploymentArchives) {
            for (BeanDeploymentArchiveImpl target : beanDeploymentArchives) {
                if (!from.isAccessible((BeanDeploymentArchive)target)) continue;
                from.addBeanDeploymentArchive((BeanDeploymentArchive)target);
            }
        }
    }

    private void makeTopLevelBdasVisibleFromStaticModules() {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL) && !bda.getBeanArchiveType().equals((Object)BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC)) continue;
            for (BeanDeploymentArchiveImpl topLevelBda : this.rootBeanDeploymentModule.getBeanDeploymentArchives()) {
                bda.addBeanDeploymentArchive((BeanDeploymentArchive)topLevelBda);
            }
        }
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableSet(new HashSet<BeanDeploymentArchiveImpl>(this.beanDeploymentArchives));
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    public ServiceRegistry getServices() {
        return this.serviceRegistry;
    }

    public synchronized BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        BeanDeploymentArchive bda = this.getBeanDeploymentArchive(beanClass);
        if (bda != null) {
            return bda;
        }
        Module module = Module.forClass(beanClass);
        if (module == null) {
            if (this.bootstrapClassLoaderBeanDeploymentArchive == null) {
                this.bootstrapClassLoaderBeanDeploymentArchive = this.createAndRegisterAdditionalBeanDeploymentArchive(module, beanClass);
            } else {
                this.bootstrapClassLoaderBeanDeploymentArchive.addBeanClass(beanClass);
            }
            return this.bootstrapClassLoaderBeanDeploymentArchive;
        }
        return this.createAndRegisterAdditionalBeanDeploymentArchive(module, beanClass);
    }

    protected BeanDeploymentArchiveImpl createAndRegisterAdditionalBeanDeploymentArchive(Module module, Class<?> beanClass) {
        String id = null;
        id = module == null ? BOOTSTRAP_CLASSLOADER_BDA_ID : module.getIdentifier() + ADDITIONAL_CLASSES_BDA_SUFFIX;
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(Collections.singleton(beanClass.getName()), BeansXml.EMPTY_BEANS_XML, module, id, BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC, false);
        WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered((BeanDeploymentArchive)newBda);
        newBda.addBeanClass(beanClass);
        newBda.getServices().addAll((Collection)this.serviceRegistry.entrySet());
        if (module != null && this.eeModuleDescriptors.containsKey(module.getIdentifier())) {
            newBda.getServices().add(EEModuleDescriptor.class, (Service)this.eeModuleDescriptors.get(module.getIdentifier()));
        }
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!newBda.isAccessible((BeanDeploymentArchive)bda)) continue;
            newBda.addBeanDeploymentArchive((BeanDeploymentArchive)bda);
        }
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            if (!bda.isAccessible((BeanDeploymentArchive)newBda)) continue;
            bda.addBeanDeploymentArchive((BeanDeploymentArchive)newBda);
        }
        newBda.addBeanDeploymentArchives(this.rootBeanDeploymentModule.getBeanDeploymentArchives());
        ClassLoader cl = beanClass.getClassLoader();
        if (cl != null) {
            this.additionalBeanDeploymentArchivesByClassloader.put(cl, newBda);
        }
        this.beanDeploymentArchives.add(newBda);
        return newBda;
    }

    public Module getModule() {
        return this.module;
    }

    public Set<ClassLoader> getSubDeploymentClassLoaders() {
        return Collections.unmodifiableSet(this.subDeploymentClassLoaders);
    }

    public synchronized <T extends Service> void addWeldService(Class<T> type, T service) {
        this.serviceRegistry.add(type, service);
        for (BeanDeploymentArchiveImpl bda : this.additionalBeanDeploymentArchivesByClassloader.values()) {
            bda.getServices().add(type, service);
        }
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        ClassLoader moduleClassLoader = WildFlySecurityManager.getClassLoaderPrivileged(beanClass);
        if (moduleClassLoader != null) {
            for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
                if (!bda.getBeanClasses().contains(beanClass.getName()) || !moduleClassLoader.equals(bda.getClassLoader())) continue;
                return bda;
            }
        }
        if (moduleClassLoader != null && this.additionalBeanDeploymentArchivesByClassloader.containsKey(moduleClassLoader)) {
            return (BeanDeploymentArchive)this.additionalBeanDeploymentArchivesByClassloader.get(moduleClassLoader);
        }
        return null;
    }
}

