/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Event;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Measures message delivery times")
public class DELIVERY_TIME
extends Protocol {
    protected AverageMinMax delivery_times = new AverageMinMax();

    @ManagedAttribute(description="Average delivery time (in microseconds). This is computed as the average delivery time for single messages, plus the delivery time for batches divided by batch size")
    public double getAvgDeliveryTime() {
        return this.delivery_times.average();
    }

    @Override
    public void resetStats() {
        this.delivery_times.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        if (evt.getType() != 1) {
            return this.up_prot.up(evt);
        }
        long start = Util.micros();
        try {
            Object object = this.up_prot.up(evt);
            return object;
        }
        finally {
            long time = Util.micros() - start;
            this.delivery_times.add(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        int batch_size = batch.size();
        long start = Util.micros();
        try {
            this.up_prot.up(batch);
        }
        finally {
            long time = Util.micros() - start;
            if (batch_size > 1) {
                time /= (long)batch.size();
            }
            this.delivery_times.add(time);
        }
    }
}

