/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.encoders;

import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.internal.util.ReflectUtils;
import org.eclipse.jetty.websocket.jakarta.common.InitException;
import org.eclipse.jetty.websocket.jakarta.common.encoders.BooleanEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.ByteArrayEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.ByteBufferEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.ByteEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.CharacterEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.DoubleEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.FloatEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.IntegerEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.LongEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.ShortEncoder;
import org.eclipse.jetty.websocket.jakarta.common.encoders.StringEncoder;

public class AvailableEncoders
implements Predicate<Class<?>> {
    private final EndpointConfig config;
    private LinkedList<RegisteredEncoder> registeredEncoders;

    public AvailableEncoders(EndpointConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.registeredEncoders = new LinkedList();
        this.registerPrimitive(BooleanEncoder.class, Encoder.Text.class, Boolean.class);
        this.registerPrimitive(ByteEncoder.class, Encoder.Text.class, Byte.class);
        this.registerPrimitive(CharacterEncoder.class, Encoder.Text.class, Character.class);
        this.registerPrimitive(DoubleEncoder.class, Encoder.Text.class, Double.class);
        this.registerPrimitive(FloatEncoder.class, Encoder.Text.class, Float.class);
        this.registerPrimitive(ShortEncoder.class, Encoder.Text.class, Short.class);
        this.registerPrimitive(IntegerEncoder.class, Encoder.Text.class, Integer.class);
        this.registerPrimitive(LongEncoder.class, Encoder.Text.class, Long.class);
        this.registerPrimitive(StringEncoder.class, Encoder.Text.class, String.class);
        this.registerPrimitive(BooleanEncoder.class, Encoder.Text.class, Boolean.TYPE);
        this.registerPrimitive(ByteEncoder.class, Encoder.Text.class, Byte.TYPE);
        this.registerPrimitive(CharacterEncoder.class, Encoder.Text.class, Character.TYPE);
        this.registerPrimitive(DoubleEncoder.class, Encoder.Text.class, Double.TYPE);
        this.registerPrimitive(FloatEncoder.class, Encoder.Text.class, Float.TYPE);
        this.registerPrimitive(ShortEncoder.class, Encoder.Text.class, Short.TYPE);
        this.registerPrimitive(IntegerEncoder.class, Encoder.Text.class, Integer.TYPE);
        this.registerPrimitive(LongEncoder.class, Encoder.Text.class, Long.TYPE);
        this.registerPrimitive(ByteBufferEncoder.class, Encoder.Binary.class, ByteBuffer.class);
        this.registerPrimitive(ByteArrayEncoder.class, Encoder.Binary.class, byte[].class);
        this.registerAll(config.getEncoders());
    }

    private void registerPrimitive(Class<? extends Encoder> encoderClass, Class<? extends Encoder> interfaceType, Class<?> type) {
        this.registeredEncoders.add(new RegisteredEncoder(encoderClass, interfaceType, type, true));
    }

    public void register(Class<? extends Encoder> encoder) {
        if (!ReflectUtils.isDefaultConstructable(encoder)) {
            throw new InvalidSignatureException("Encoder must have public, no-args constructor: " + encoder.getName());
        }
        boolean foundEncoder = false;
        if (Encoder.Binary.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.Binary.class);
            foundEncoder = true;
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.BinaryStream.class);
            foundEncoder = true;
        }
        if (Encoder.Text.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.Text.class);
            foundEncoder = true;
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.TextStream.class);
            foundEncoder = true;
        }
        if (!foundEncoder) {
            throw new InvalidSignatureException("Not a valid Encoder class: " + encoder.getName() + " implements no " + Encoder.class.getName() + " interfaces");
        }
    }

    public void registerAll(Class<? extends Encoder>[] encoders) {
        if (encoders == null) {
            return;
        }
        for (Class<? extends Encoder> encoder : encoders) {
            this.register(encoder);
        }
    }

    public void registerAll(List<Class<? extends Encoder>> encoders) {
        if (encoders == null) {
            return;
        }
        encoders.forEach(this::register);
    }

    private void add(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceClass) {
        Class objectType = ReflectUtils.findGenericClassFor(encoder, interfaceClass);
        if (objectType == null) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid Encoder Object type declared for interface ");
            err.append(interfaceClass.getName());
            err.append(" on class ");
            err.append(encoder);
            throw new InvalidWebSocketException(err.toString());
        }
        try {
            RegisteredEncoder conflicts = this.registeredEncoders.stream().filter(registered -> registered.isType(objectType)).filter(registered -> !registered.primitive).findFirst().get();
            if (conflicts.encoder.equals(encoder) && conflicts.implementsInterface(interfaceClass)) {
                return;
            }
            StringBuilder err = new StringBuilder();
            err.append("Duplicate Encoder Object type ");
            err.append(objectType.getName());
            err.append(" in ");
            err.append(encoder.getName());
            err.append(", previously declared in ");
            err.append(conflicts.encoder.getName());
            throw new InvalidWebSocketException(err.toString());
        }
        catch (NoSuchElementException e) {
            this.registeredEncoders.addFirst(new RegisteredEncoder(encoder, interfaceClass, objectType));
            return;
        }
    }

    public List<RegisteredEncoder> supporting(Class<? extends Encoder> interfaceType) {
        return this.registeredEncoders.stream().filter(registered -> registered.implementsInterface(interfaceType)).collect(Collectors.toList());
    }

    public RegisteredEncoder getRegisteredEncoderFor(Class<?> type) {
        return this.registeredEncoders.stream().filter(registered -> registered.isType(type)).findFirst().get();
    }

    public Class<? extends Encoder> getEncoderFor(Class<?> type) {
        try {
            return this.getRegisteredEncoderFor(type).encoder;
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Encoder found for type " + type);
        }
    }

    public Encoder getInstanceFor(Class<?> type) {
        try {
            RegisteredEncoder registeredEncoder = this.getRegisteredEncoderFor(type);
            if (registeredEncoder.instance != null) {
                return registeredEncoder.instance;
            }
            registeredEncoder.instance = registeredEncoder.encoder.getConstructor(new Class[0]).newInstance(new Object[0]);
            registeredEncoder.instance.init(this.config);
            return registeredEncoder.instance;
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Encoder found for type " + type);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InitException("Unable to init Encoder for type:" + type.getName(), e);
        }
    }

    @Override
    public boolean test(Class<?> type) {
        return this.registeredEncoders.stream().anyMatch(registered -> registered.isType(type));
    }

    public static class RegisteredEncoder {
        public final Class<? extends Encoder> encoder;
        public final Class<? extends Encoder> interfaceType;
        public final Class<?> objectType;
        public final boolean primitive;
        public Encoder instance;

        public RegisteredEncoder(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceType, Class<?> objectType) {
            this(encoder, interfaceType, objectType, false);
        }

        public RegisteredEncoder(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceType, Class<?> objectType, boolean primitive) {
            this.encoder = encoder;
            this.interfaceType = interfaceType;
            this.objectType = objectType;
            this.primitive = primitive;
        }

        public boolean implementsInterface(Class<? extends Encoder> type) {
            return this.interfaceType.isAssignableFrom(type);
        }

        public boolean isType(Class<?> type) {
            return this.objectType.isAssignableFrom(type);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(RegisteredEncoder.class.getSimpleName());
            str.append('[').append(this.encoder.getName());
            str.append(',').append(this.interfaceType.getName());
            str.append(',').append(this.objectType.getName());
            if (this.primitive) {
                str.append(",PRIMITIVE");
            }
            str.append(']');
            return str.toString();
        }
    }
}

