/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.io.IOException;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.infinispan.protostream.MessageMarshaller;

public class SessionDataMarshaller
implements MessageMarshaller<InfinispanSessionData> {
    private static final int VERSION = 0;

    public Class<? extends InfinispanSessionData> getJavaClass() {
        return InfinispanSessionData.class;
    }

    public String getTypeName() {
        return "org_eclipse_jetty_session_infinispan.InfinispanSessionData";
    }

    public InfinispanSessionData readFrom(MessageMarshaller.ProtoStreamReader in) throws IOException {
        int version = in.readInt("version");
        String id = in.readString("id");
        String cpath = in.readString("contextPath");
        String vhost = in.readString("vhost");
        long accessed = in.readLong("accessed");
        long lastAccessed = in.readLong("lastAccessed");
        long created = in.readLong("created");
        long cookieSet = in.readLong("cookieSet");
        String lastNode = in.readString("lastNode");
        long expiry = in.readLong("expiry");
        long maxInactiveMs = in.readLong("maxInactiveMs");
        InfinispanSessionData sd = new InfinispanSessionData(id, cpath, vhost, created, accessed, lastAccessed, maxInactiveMs);
        sd.setCookieSet(cookieSet);
        sd.setLastNode(lastNode);
        sd.setExpiry(expiry);
        if (version == 0) {
            byte[] attributeArray = in.readBytes("attributes");
            sd.setSerializedAttributes(attributeArray);
            return sd;
        }
        throw new IOException("Unrecognized infinispan session version " + version);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter out, InfinispanSessionData sdata) throws IOException {
        out.writeInt("version", 0);
        out.writeString("id", sdata.getId());
        out.writeString("contextPath", sdata.getContextPath());
        out.writeString("vhost", sdata.getVhost());
        out.writeLong("accessed", sdata.getAccessed());
        out.writeLong("lastAccessed", sdata.getLastAccessed());
        out.writeLong("created", sdata.getCreated());
        out.writeLong("cookieSet", sdata.getCookieSet());
        out.writeString("lastNode", sdata.getLastNode());
        out.writeLong("expiry", sdata.getExpiry());
        out.writeLong("maxInactiveMs", sdata.getMaxInactiveMs());
        sdata.serializeAttributes();
        out.writeBytes("attributes", sdata.getSerializedAttributes());
    }
}

