/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.gcloud.memcached.session;

import com.google.cloud.datastore.Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import org.eclipse.jetty.gcloud.session.GCloudSessionManager;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GCloudMemcachedSessionManager
extends GCloudSessionManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected String _host;
    protected String _port;
    protected MemcachedClient _client;
    protected int _expirySec = 0;
    private boolean _heartbeats = true;

    public int getExpirySec() {
        return this._expirySec;
    }

    public void setExpirySec(int expirySec) {
        this._expirySec = expirySec;
    }

    public void setHeartbeats(boolean heartbeats) {
        this._heartbeats = heartbeats;
    }

    public void doStart() throws Exception {
        if (StringUtil.isBlank((String)this._host) || StringUtil.isBlank((String)this._port)) {
            throw new IllegalStateException("Memcached host and/or port not configured");
        }
        LOG.info("Memcached host {} port {}", new Object[]{this._host, this._port});
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(this._host + ":" + this._port);
        this._client = builder.build();
        this._client.setEnableHeartBeat(this._heartbeats);
        this._client.setTranscoder((Transcoder)new ContextClassloaderSerializingTranscoder());
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        this._client.shutdown();
        this._client = null;
    }

    protected GCloudSessionManager.Session load(Key key) throws Exception {
        GCloudSessionManager.Session session;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading key {} from memcached ", new Object[]{key.name()});
        }
        if ((session = this.loadFromMemcached(key.name())) != null) {
            return session;
        }
        return super.load(key);
    }

    protected GCloudSessionManager.Session loadFromMemcached(String key) throws Exception {
        SerializableSessionData sd = (SerializableSessionData)this._client.get(key);
        if (sd == null) {
            return null;
        }
        MemcacheSession session = new MemcacheSession(sd.clusterId, sd.createTime, sd.accessed, sd.maxInactive);
        session.setLastNode(sd.lastNode);
        session.setContextPath(sd.contextPath);
        session.setVHost(sd.vhost);
        session.setCookieSetTime(sd.cookieSetTime);
        session.setLastAccessedTime(sd.lastAccessed);
        session.setLastNode(sd.lastNode);
        session.setExpiry(sd.expiry);
        session.addAttributes(sd.attributes);
        return session;
    }

    protected void save(GCloudSessionManager.Session session) throws Exception {
        super.save(session);
        this.saveToMemcached(session);
    }

    protected void delete(GCloudSessionManager.Session session) {
        Exception memcacheException = null;
        try {
            this.deleteFromMemcached(session);
        }
        catch (Exception e) {
            memcacheException = e;
        }
        super.delete(session);
        if (memcacheException != null) {
            throw new RuntimeException(memcacheException);
        }
    }

    protected void deleteFromMemcached(GCloudSessionManager.Session session) throws Exception {
        Key gcloudKey = this.makeKey(session, this._context);
        this._client.delete(gcloudKey.name());
    }

    protected void saveToMemcached(GCloudSessionManager.Session session) throws Exception {
        Key gcloudKey = this.makeKey(session, this._context);
        this._client.set(gcloudKey.name(), this.getExpirySec(), (Object)new SerializableSessionData(session));
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public class SerializableSessionData
    implements Serializable {
        private static final long serialVersionUID = -7779120106058533486L;
        String clusterId;
        String contextPath;
        String vhost;
        long accessed;
        long lastAccessed;
        long createTime;
        long cookieSetTime;
        String lastNode;
        long expiry;
        long maxInactive;
        Map<String, Object> attributes;

        public SerializableSessionData() {
        }

        public SerializableSessionData(GCloudSessionManager.Session s) {
            this.clusterId = s.getClusterId();
            this.contextPath = s.getContextPath();
            this.vhost = s.getVHost();
            this.accessed = s.getAccessed();
            this.lastAccessed = s.getLastAccessedTime();
            this.createTime = s.getCreationTime();
            this.cookieSetTime = s.getCookieSetTime();
            this.lastNode = s.getLastNode();
            this.expiry = s.getExpiry();
            this.maxInactive = s.getMaxInactiveInterval();
            this.attributes = s.getAttributeMap();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.clusterId);
            out.writeUTF(this.contextPath);
            out.writeUTF(this.vhost);
            out.writeLong(this.accessed);
            out.writeLong(this.lastAccessed);
            out.writeLong(this.createTime);
            out.writeLong(this.cookieSetTime);
            out.writeUTF(this.lastNode);
            out.writeLong(this.expiry);
            out.writeLong(this.maxInactive);
            out.writeObject(this.attributes);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.clusterId = ois.readUTF();
            this.contextPath = ois.readUTF();
            this.vhost = ois.readUTF();
            this.accessed = ois.readLong();
            this.lastAccessed = ois.readLong();
            this.createTime = ois.readLong();
            this.cookieSetTime = ois.readLong();
            this.lastNode = ois.readUTF();
            this.expiry = ois.readLong();
            this.maxInactive = ois.readLong();
            Object o = ois.readObject();
            this.attributes = (Map)o;
        }
    }

    public class MemcacheSession
    extends GCloudSessionManager.Session {
        public MemcacheSession(String sessionId, long created, long accessed, long maxInterval) {
            super((GCloudSessionManager)GCloudMemcachedSessionManager.this, sessionId, created, accessed, maxInterval);
        }
    }

    public class ContextClassloaderSerializingTranscoder
    extends SerializingTranscoder {
        protected Object deserialize(byte[] in) {
            if (in == null) {
                return null;
            }
            Object rv = null;
            try (ByteArrayInputStream bis = new ByteArrayInputStream(in);
                 ClassLoadingObjectInputStream is = new ClassLoadingObjectInputStream((InputStream)bis);){
                rv = is.readObject();
            }
            catch (IOException e) {
                LOG.warn("Caught IOException decoding " + in.length + " bytes of data", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Caught CNFE decoding " + in.length + " bytes of data", (Throwable)e);
            }
            return rv;
        }
    }
}

