/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Flusher
extends IteratingCallback {
    private static final Logger LOG = Log.getLogger(HTTP2Flusher.class);
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final List<Entry> frames = new ArrayList<Entry>();
    private final Map<IStream, Integer> streams = new HashMap<IStream, Integer>();
    private final List<Entry> resets = new ArrayList<Entry>();
    private final List<Entry> actives = new ArrayList<Entry>();
    private final HTTP2Session session;
    private final ByteBufferPool.Lease lease;
    private Throwable terminated;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
        this.lease = new ByteBufferPool.Lease(session.getGenerator().getByteBufferPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(IStream stream, WindowUpdateFrame frame) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.frames.add(0, entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.frames.add(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry remove(int index) {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IteratingCallback.Action process() throws Throwable {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", new Object[]{this.session});
        }
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.terminated != null) {
                throw this.terminated;
            }
            while (!this.windows.isEmpty()) {
                WindowEntry entry = this.windows.poll();
                entry.perform();
            }
            int sessionWindow = this.session.getSendWindow();
            int index = 0;
            int size = this.frames.size();
            while (index < size) {
                Entry entry = this.frames.get(index);
                IStream stream = entry.stream;
                if (stream != null && stream.isReset() && !entry.isProtocol()) {
                    this.remove(index);
                    --size;
                    this.resets.add(entry);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Gathered for reset {}", new Object[]{entry});
                    continue;
                }
                int remaining = entry.dataRemaining();
                if (remaining > 0) {
                    if (sessionWindow <= 0) {
                        ++index;
                        continue;
                    }
                    if (stream != null) {
                        Integer streamWindow = this.streams.get(stream);
                        if (streamWindow == null) {
                            streamWindow = stream.updateSendWindow(0);
                            this.streams.put(stream, streamWindow);
                        }
                        if (streamWindow <= 0) {
                            ++index;
                            continue;
                        }
                    }
                    sessionWindow -= remaining;
                    if (stream != null) {
                        this.streams.put(stream, this.streams.get(stream) - remaining);
                    }
                }
                this.remove(index);
                --size;
                this.actives.add(entry);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Gathered for write {}", new Object[]{entry});
            }
            this.streams.clear();
        }
        for (i = 0; i < this.resets.size(); ++i) {
            Entry entry = this.resets.get(i);
            entry.reset();
        }
        this.resets.clear();
        if (this.actives.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed {}", new Object[]{this.session});
            }
            return IteratingCallback.Action.IDLE;
        }
        for (i = 0; i < this.actives.size(); ++i) {
            Entry entry = this.actives.get(i);
            Throwable failure = entry.generate(this.lease);
            if (failure == null) continue;
            this.failed(failure);
            return IteratingCallback.Action.SUCCEEDED;
        }
        List byteBuffers = this.lease.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} buffers ({} bytes) for {} frames {}", new Object[]{byteBuffers.size(), this.lease.getTotalLength(), this.actives.size(), this.actives});
        }
        this.session.getEndPoint().write((Callback)this, byteBuffers.toArray(new ByteBuffer[byteBuffers.size()]));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        this.lease.recycle();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written {} frames for {}", new Object[]{this.actives.size(), this.actives});
        }
        this.actives.forEach(Callback.Nested::succeeded);
        this.actives.clear();
        super.succeeded();
    }

    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleteFailure(Throwable x) {
        Throwable closed;
        this.lease.recycle();
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = x;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}, active/queued={}/{}", new Object[]{closed != null ? "Closing" : "Failing", this.actives.size(), this.frames.size()});
            }
            this.actives.addAll(this.frames);
            this.frames.clear();
        }
        this.actives.forEach(entry -> entry.failed(x));
        this.actives.clear();
        if (closed == null) {
            this.session.abort(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Throwable cause) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = cause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", new Object[]{closed != null ? "Terminated" : "Terminating"});
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    private class WindowEntry {
        private final IStream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(IStream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    extends Callback.Nested {
        protected final Frame frame;
        protected final IStream stream;

        protected Entry(Frame frame, IStream stream, Callback callback) {
            super(callback);
            this.frame = frame;
            this.stream = stream;
        }

        public int dataRemaining() {
            return 0;
        }

        public Throwable generate(ByteBufferPool.Lease lease) {
            return null;
        }

        public void reset() {
            this.failed((Throwable)new EofException("reset"));
        }

        public void failed(Throwable x) {
            if (this.stream != null) {
                this.stream.close();
                this.stream.getSession().removeStream(this.stream);
            }
            super.failed(x);
        }

        public boolean isProtocol() {
            switch (this.frame.getType()) {
                case PRIORITY: 
                case RST_STREAM: 
                case GO_AWAY: 
                case WINDOW_UPDATE: 
                case DISCONNECT: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

