/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.gcloud.session;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.gcloud.session.GCloudSessionManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GCloudSessionIdManager
extends AbstractSessionIdManager {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final int DEFAULT_IDLE_EXPIRY_MULTIPLE = 2;
    public static final String KIND = "GCloudSessionId";
    private Server _server;
    private Datastore _datastore;
    private KeyFactory _keyFactory;

    public GCloudSessionIdManager(Server server) {
        this._server = server;
    }

    public GCloudSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    protected void doStart() throws Exception {
        this._datastore = (Datastore)DatastoreOptions.defaultInstance().service();
        this._keyFactory = (KeyFactory)this._datastore.newKeyFactory().kind(KIND);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String clusterId = this.getClusterId(id);
        try {
            return this.exists(clusterId);
        }
        catch (Exception e) {
            LOG.warn("Problem checking inUse for id=" + clusterId, (Throwable)e);
            return false;
        }
    }

    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.insert(((AbstractSession)session).getClusterId());
    }

    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.delete(((AbstractSession)session).getClusterId());
    }

    public void invalidateAll(String id) {
        this.delete(id);
        Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof GCloudSessionManager)) continue;
            ((GCloudSessionManager)manager).invalidateSession(id);
        }
    }

    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        this.delete(oldClusterId);
        this.insert(newClusterId);
        Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof GCloudSessionManager)) continue;
            ((GCloudSessionManager)manager).renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
        }
    }

    protected boolean exists(String id) {
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        Key key = this._keyFactory.newKey(id);
        return this._datastore.get(key) != null;
    }

    protected void insert(String id) {
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        Entity entity = ((Entity.Builder)Entity.builder((Key)this.makeKey(id)).set("id", id)).build();
        this._datastore.put((FullEntity)entity);
    }

    protected void delete(String id) {
        if (this._datastore == null) {
            throw new IllegalStateException("No DataStore");
        }
        this._datastore.delete(new Key[]{this.makeKey(id)});
    }

    protected Key makeKey(String id) {
        return this._keyFactory.newKey(id);
    }
}

