/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.fcgi.client.http.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpReceiverOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpSenderOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;

public class HttpChannelOverFCGI
extends HttpChannel {
    private final HttpConnectionOverFCGI connection;
    private final Flusher flusher;
    private final int request;
    private final HttpSenderOverFCGI sender;
    private final HttpReceiverOverFCGI receiver;
    private final FCGIIdleTimeout idle;
    private HttpVersion version;

    public HttpChannelOverFCGI(HttpConnectionOverFCGI connection, Flusher flusher, int request, long idleTimeout) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.flusher = flusher;
        this.request = request;
        this.sender = new HttpSenderOverFCGI(this);
        this.receiver = new HttpReceiverOverFCGI(this);
        this.idle = new FCGIIdleTimeout(connection, idleTimeout);
    }

    protected int getRequest() {
        return this.request;
    }

    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.version = exchange.getRequest().getVersion();
            this.sender.send(exchange);
        }
    }

    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    public boolean abort(Throwable cause) {
        boolean sendAborted = this.sender.abort(cause);
        boolean receiveAborted = this.abortResponse(cause);
        return sendAborted || receiveAborted;
    }

    public boolean abortResponse(Throwable cause) {
        return this.receiver.abort(cause);
    }

    protected boolean responseBegin(int code, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        exchange.getResponse().version(this.version).status(code).reason(reason);
        return this.receiver.responseBegin(exchange);
    }

    protected boolean responseHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseHeader(exchange, field);
    }

    protected boolean responseHeaders() {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseHeaders(exchange);
    }

    protected boolean content(ByteBuffer buffer, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            return this.receiver.responseContent(exchange, buffer, callback);
        }
        callback.succeeded();
        return false;
    }

    protected boolean responseSuccess() {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseSuccess(exchange);
    }

    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null && this.receiver.responseFailure(failure);
    }

    public void exchangeTerminated(Result result) {
        super.exchangeTerminated(result);
        this.idle.onClose();
        HttpFields responseHeaders = result.getResponse().getHeaders();
        if (result.isFailed()) {
            this.connection.close(result.getFailure());
        } else if (!this.connection.closeByHTTP(responseHeaders)) {
            this.connection.release(this);
        }
    }

    protected void flush(Generator.Result ... results) {
        this.flusher.flush(results);
    }

    private class FCGIIdleTimeout
    extends IdleTimeout {
        private final HttpConnectionOverFCGI connection;

        public FCGIIdleTimeout(HttpConnectionOverFCGI connection, long idleTimeout) {
            super(connection.getHttpDestination().getHttpClient().getScheduler());
            this.connection = connection;
            this.setIdleTimeout(idleTimeout);
        }

        protected void onIdleExpired(TimeoutException timeout) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout for request {}", (long)HttpChannelOverFCGI.this.request);
            }
            this.connection.abort(timeout);
        }

        public boolean isOpen() {
            return this.connection.getEndPoint().isOpen();
        }
    }
}

