/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.server.pathmap.PathMappings;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

@ManagedObject(value="WebSocket Upgrade Filter")
public class WebSocketUpgradeFilter
extends AbstractLifeCycle
implements Filter,
MappedWebSocketCreator,
Dumpable {
    public static final String CONTEXT_ATTRIBUTE_KEY = "contextAttributeKey";
    public static final String CONFIG_ATTRIBUTE_KEY = "configAttributeKey";
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeFilter.class);
    private NativeWebSocketConfiguration configuration;
    private boolean alreadySetToAttribute = false;

    public static WebSocketUpgradeFilter configureContext(ServletContextHandler context) throws ServletException {
        WebSocketUpgradeFilter filter = (WebSocketUpgradeFilter)context.getAttribute(WebSocketUpgradeFilter.class.getName());
        if (filter != null) {
            return filter;
        }
        NativeWebSocketConfiguration configuration = NativeWebSocketServletContainerInitializer.getDefaultFrom((ServletContext)context.getServletContext());
        filter = new WebSocketUpgradeFilter(configuration);
        filter.setToAttribute(context, WebSocketUpgradeFilter.class.getName());
        String name = "Jetty_WebSocketUpgradeFilter";
        String pathSpec = "/*";
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
        FilterHolder fholder = new FilterHolder((Filter)filter);
        fholder.setName(name);
        fholder.setAsyncSupported(true);
        fholder.setInitParameter(CONTEXT_ATTRIBUTE_KEY, WebSocketUpgradeFilter.class.getName());
        context.addFilter(fholder, pathSpec, dispatcherTypes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding [{}] {} mapped to {} to {}", new Object[]{name, filter, pathSpec, context});
        }
        return filter;
    }

    @Deprecated
    public static WebSocketUpgradeFilter configureContext(ServletContext context) throws ServletException {
        ContextHandler handler = ContextHandler.getContextHandler((ServletContext)context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, WebSocket support unavailable");
        }
        if (!(handler instanceof ServletContextHandler)) {
            throw new ServletException("Not running in Jetty ServletContextHandler, WebSocket support via " + WebSocketUpgradeFilter.class.getName() + " unavailable");
        }
        return WebSocketUpgradeFilter.configureContext((ServletContextHandler)handler);
    }

    public WebSocketUpgradeFilter() {
    }

    public WebSocketUpgradeFilter(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(new NativeWebSocketConfiguration(new WebSocketServerFactory(policy, bufferPool)));
    }

    public WebSocketUpgradeFilter(NativeWebSocketConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void addMapping(org.eclipse.jetty.http.pathmap.PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    @Deprecated
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public void addMapping(String spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public boolean removeMapping(String spec) {
        return this.configuration.removeMapping(spec);
    }

    public void destroy() {
        try {
            this.alreadySetToAttribute = false;
            this.configuration.stop();
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block10: {
            if (this.configuration == null) {
                LOG.debug("WebSocketUpgradeFilter is not operational - missing " + NativeWebSocketConfiguration.class.getName(), new Object[0]);
                chain.doFilter(request, response);
                return;
            }
            WebSocketServerFactory factory = this.configuration.getFactory();
            if (factory == null) {
                LOG.debug("WebSocketUpgradeFilter is not operational - no WebSocketServletFactory configured", new Object[0]);
                chain.doFilter(request, response);
                return;
            }
            try {
                MappedResource<WebSocketCreator> resource;
                HttpServletRequest httpreq = (HttpServletRequest)request;
                HttpServletResponse httpresp = (HttpServletResponse)response;
                if (!factory.isUpgradeRequest(httpreq, httpresp)) {
                    chain.doFilter(request, response);
                    return;
                }
                String contextPath = httpreq.getContextPath();
                String target = httpreq.getRequestURI();
                if (target.startsWith(contextPath)) {
                    target = target.substring(contextPath.length());
                }
                if ((resource = this.configuration.getMatch(target)) == null) {
                    chain.doFilter(request, response);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WebSocket Upgrade detected on {} for endpoint {}", new Object[]{target, resource});
                }
                WebSocketCreator creator = (WebSocketCreator)resource.getResource();
                httpreq.setAttribute(org.eclipse.jetty.http.pathmap.PathSpec.class.getName(), (Object)resource.getPathSpec());
                if (factory.acceptWebSocket(creator, httpreq, httpresp)) {
                    return;
                }
                if (response.isCommitted()) {
                    return;
                }
            }
            catch (ClassCastException e) {
                if (!LOG.isDebugEnabled()) break block10;
                LOG.debug("Not a HttpServletRequest, skipping WebSocketUpgradeFilter", new Object[0]);
            }
        }
        chain.doFilter(request, response);
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(indent).append(" +- configuration=").append(this.configuration.toString()).append("\n");
        this.configuration.dump(out, indent);
    }

    public WebSocketServletFactory getFactory() {
        return this.configuration.getFactory();
    }

    @ManagedAttribute(value="configuration", readonly=true)
    public NativeWebSocketConfiguration getConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(this.getClass().getName() + " not initialized yet");
        }
        return this.configuration;
    }

    @Override
    public WebSocketCreator getMapping(String target) {
        return this.getConfiguration().getMapping(target);
    }

    @Override
    @Deprecated
    public PathMappings<WebSocketCreator> getMappings() {
        throw new IllegalStateException("Access to PathMappings cannot be supported. See alternative API in javadoc for " + MappedWebSocketCreator.class.getName());
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            String key;
            String configurationKey = config.getInitParameter(CONFIG_ATTRIBUTE_KEY);
            if (configurationKey == null) {
                configurationKey = NativeWebSocketConfiguration.class.getName();
            }
            if (this.configuration == null) {
                this.configuration = (NativeWebSocketConfiguration)config.getServletContext().getAttribute(configurationKey);
                if (this.configuration == null) {
                    throw new ServletException("Unable to find required instance of " + NativeWebSocketConfiguration.class.getName() + " at ServletContext attribute '" + configurationKey + "'");
                }
            } else if (config.getServletContext().getAttribute(configurationKey) == null) {
                config.getServletContext().setAttribute(configurationKey, (Object)this.configuration);
            }
            this.configuration.start();
            String max = config.getInitParameter("maxIdleTime");
            if (max != null) {
                this.getFactory().getPolicy().setIdleTimeout(Long.parseLong(max));
            }
            if ((max = config.getInitParameter("maxTextMessageSize")) != null) {
                this.getFactory().getPolicy().setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("maxBinaryMessageSize")) != null) {
                this.getFactory().getPolicy().setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("inputBufferSize")) != null) {
                this.getFactory().getPolicy().setInputBufferSize(Integer.parseInt(max));
            }
            if ((key = config.getInitParameter(CONTEXT_ATTRIBUTE_KEY)) == null) {
                key = WebSocketUpgradeFilter.class.getName();
            }
            this.setToAttribute(config.getServletContext(), key);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void setToAttribute(ServletContextHandler context, String key) throws ServletException {
        this.setToAttribute((ServletContext)context.getServletContext(), key);
    }

    public void setToAttribute(ServletContext context, String key) throws ServletException {
        if (this.alreadySetToAttribute) {
            return;
        }
        if (context.getAttribute(key) != null) {
            throw new ServletException(WebSocketUpgradeFilter.class.getName() + " is defined twice for the same context attribute key '" + key + "'.  Make sure you have different init-param '" + CONTEXT_ATTRIBUTE_KEY + "' values set");
        }
        context.setAttribute(key, (Object)this);
        this.alreadySetToAttribute = true;
    }

    public String toString() {
        return String.format("%s[configuration=%s]", this.getClass().getSimpleName(), this.configuration);
    }
}

