/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.jboss.logging.Logger;

public class JDBCSequentialFile
implements SequentialFile {
    private static final Logger logger = Logger.getLogger(JDBCSequentialFile.class);
    private final String filename;
    private final String extension;
    private boolean isOpen = false;
    private boolean isLoaded = false;
    private long id = -1L;
    private long readPosition = 0L;
    private long writePosition = 0L;
    private final Executor executor;
    private final JDBCSequentialFileFactory fileFactory;
    private final Object writeLock;
    private final JDBCSequentialFileFactoryDriver dbDriver;
    private final Map<Object, Object> metaData = new ConcurrentHashMap<Object, Object>();

    JDBCSequentialFile(JDBCSequentialFileFactory fileFactory, String filename, Executor executor, JDBCSequentialFileFactoryDriver driver, Object writeLock) throws SQLException {
        this.fileFactory = fileFactory;
        this.filename = filename;
        this.extension = filename.contains(".") ? filename.substring(filename.lastIndexOf(".") + 1, filename.length()) : "";
        this.executor = executor;
        this.writeLock = writeLock;
        this.dbDriver = driver;
    }

    void setWritePosition(long writePosition) {
        this.writePosition = writePosition;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean exists() {
        if (this.isLoaded) {
            return true;
        }
        try {
            return this.fileFactory.listFiles(this.extension).contains(this.filename);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            this.fileFactory.onIOError(e, "Error checking JDBC file exists.", this);
            return false;
        }
    }

    public void open() throws Exception {
        this.load();
        this.isOpen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.isLoaded) {
                    this.dbDriver.openFile(this);
                    this.isLoaded = true;
                }
            }
        }
        catch (SQLException e) {
            this.fileFactory.onIOError(e, "Error attempting to open JDBC file.", this);
        }
    }

    public void open(int maxIO, boolean useExecutor) throws Exception {
        this.open();
    }

    public boolean fits(int size) {
        return this.writePosition + (long)size <= this.dbDriver.getMaxSize();
    }

    public int calculateBlockStart(int position) throws Exception {
        return 0;
    }

    public String getFileName() {
        return this.filename;
    }

    public void fill(int size) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException, InterruptedException, ActiveMQException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                this.load();
                this.dbDriver.deleteFile(this);
            }
        }
        catch (SQLException e) {
            this.fileFactory.onIOError(e, "Error deleting JDBC file.", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int internalWrite(byte[] data, IOCallback callback) {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                int noBytes = this.dbDriver.writeToFile(this, data);
                this.seek(noBytes);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Write: ID: " + this.getId() + " FileName: " + this.getFileName() + this.size()));
                }
                if (callback != null) {
                    callback.done();
                }
                return noBytes;
            }
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            }
            this.fileFactory.onIOError(e, "Error writing to JDBC file.", this);
            return 0;
        }
    }

    public synchronized int internalWrite(ActiveMQBuffer buffer, IOCallback callback) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        return this.internalWrite(data, callback);
    }

    private synchronized int internalWrite(ByteBuffer buffer, IOCallback callback) {
        return this.internalWrite(buffer.array(), callback);
    }

    private void scheduleWrite(ActiveMQBuffer bytes, IOCallback callback) {
        this.executor.execute(() -> this.internalWrite(bytes, callback));
    }

    private void scheduleWrite(ByteBuffer bytes, IOCallback callback) {
        this.executor.execute(() -> this.internalWrite(bytes, callback));
    }

    synchronized void seek(long noBytes) {
        this.writePosition += noBytes;
    }

    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws Exception {
        this.scheduleWrite(bytes, callback);
    }

    public void write(ActiveMQBuffer bytes, boolean sync) throws Exception {
        this.write(bytes, sync, null);
    }

    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws Exception {
        ActiveMQBuffer data = ActiveMQBuffers.fixedBuffer((int)bytes.getEncodeSize());
        bytes.encode(data);
        this.scheduleWrite(data, callback);
    }

    public void write(EncodingSupport bytes, boolean sync) throws Exception {
        this.write(bytes, sync, null);
    }

    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        if (callback == null) {
            SimpleWaitIOCallback waitIOCallback = new SimpleWaitIOCallback();
            try {
                this.scheduleWrite(bytes, (IOCallback)waitIOCallback);
                waitIOCallback.waitCompletion();
            }
            catch (Exception e) {
                waitIOCallback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "Error writing to JDBC file.");
                this.fileFactory.onIOError(e, "Failed to write to file.", this);
            }
        } else {
            this.scheduleWrite(bytes, callback);
        }
    }

    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.writeDirect(bytes, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(ByteBuffer bytes, IOCallback callback) throws SQLException {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                int read = this.dbDriver.readFromFile(this, bytes);
                this.readPosition += (long)read;
                if (callback != null) {
                    callback.done();
                }
                return read;
            }
            catch (SQLException e) {
                if (callback != null) {
                    callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
                }
                this.fileFactory.onIOError(e, "Error reading from JDBC file.", this);
                return 0;
            }
        }
    }

    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    public void position(long pos) throws IOException {
        this.readPosition = pos;
    }

    public long position() {
        return this.readPosition;
    }

    public void close() throws Exception {
        this.isOpen = false;
        this.sync();
        this.fileFactory.sequentialFileClosed(this);
    }

    public void sync() throws IOException {
        SimpleWaitIOCallback callback = new SimpleWaitIOCallback();
        this.executor.execute(() -> ((SimpleWaitIOCallback)callback).done());
        try {
            callback.waitCompletion();
        }
        catch (Exception e) {
            callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "Error during JDBC file sync.");
            this.fileFactory.onIOError(e, "Error during JDBC file sync.", this);
        }
    }

    public long size() throws Exception {
        this.load();
        return this.writePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTo(String newFileName) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            try {
                this.dbDriver.renameFile(this, newFileName);
            }
            catch (SQLException e) {
                this.fileFactory.onIOError(e, "Error renaming JDBC file.", this);
            }
        }
    }

    public SequentialFile cloneFile() {
        try {
            JDBCSequentialFile clone = new JDBCSequentialFile(this.fileFactory, this.filename, this.executor, this.dbDriver, this.writeLock);
            return clone;
        }
        catch (Exception e) {
            this.fileFactory.onIOError(e, "Error cloning JDBC file.", this);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(SequentialFile cloneFile) throws Exception {
        JDBCSequentialFile clone = (JDBCSequentialFile)cloneFile;
        try {
            Object object = this.writeLock;
            synchronized (object) {
                clone.open();
                this.dbDriver.copyFileData(this, clone);
            }
        }
        catch (Exception e) {
            this.fileFactory.onIOError(e, "Error copying JDBC file.", this);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setTimedBuffer(TimedBuffer buffer) {
    }

    public File getJavaFile() {
        return null;
    }

    public void addMetaData(Object key, Object value) {
        this.metaData.put(key, value);
    }

    public Object getMetaData(Object key) {
        return this.metaData.get(key);
    }
}

