/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.integration.jbossas.vfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jboss.seam.deployment.AbstractScanner;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.integration.jbossas.vfs.FileModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.LeafVirtualFileFilter;
import org.jboss.seam.integration.jbossas.vfs.ModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.URLScannerAdapter;
import org.jboss.seam.integration.jbossas.vfs.VirtualFileModifiableResource;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class VFSScanner
extends AbstractScanner {
    protected final LogProvider log = Logging.getLogProvider(((Object)((Object)this)).getClass());
    protected static Method handleMethod;
    private final URLScannerAdapter adapter;
    private long timestamp;

    public VFSScanner(DeploymentStrategy deploymentStrategy) {
        super(deploymentStrategy);
        this.adapter = new URLScannerAdapter(deploymentStrategy);
    }

    protected VirtualFile getRoot(URL url, int parentDepth) throws IOException {
        VirtualFile top;
        this.log.trace((Object)("Root url: " + url));
        try {
            top = VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        while (parentDepth > 0) {
            if (top == null) {
                throw new IllegalArgumentException("Null parent: " + url + "Must have reached root VirtualFile");
            }
            top = top.getParent();
            --parentDepth;
        }
        this.log.trace((Object)("Top: " + top));
        return top;
    }

    public void scanDirectories(File[] directories) {
        this.scanDirectories(directories, new File[0]);
    }

    public void scanDirectories(File[] directories, File[] excludedDirectories) {
        for (File directory : directories) {
            this.handleDirectory(directory, null, excludedDirectories);
        }
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            this.log.trace((Object)("Skipping excluded directory: " + file));
            return;
        }
        FileModifiableResource delegate = new FileModifiableResource();
        this.log.trace((Object)("Handling directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories);
                continue;
            }
            delegate.setFile(child);
            try {
                this.handleItem(delegate, newPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void scanResources(String[] resources) {
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getDeploymentStrategy().getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    int p;
                    URL url = urlEnum.nextElement();
                    String protocol = url.getProtocol();
                    if (protocol.contains("vfs")) {
                        VirtualFile root = this.getRoot(url, resourceName.lastIndexOf(47) > 0 ? 2 : 1);
                        if (root.exists()) {
                            this.handleRoot(root);
                            continue;
                        }
                        this.log.trace((Object)("Root does not exist: " + url));
                        continue;
                    }
                    String urlPath = url.getFile();
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if ((p = urlPath.indexOf(33)) > 0) {
                        urlPath = urlPath.substring(0, p);
                    }
                    this.adapter.handlePath(urlPath);
                    this.checkLastModified(this.adapter.getTimestamp());
                }
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Cannot read resource: " + resourceName), (Throwable)ioe);
            }
        }
    }

    protected void handleRoot(VirtualFile root) throws IOException {
        VirtualFileModifiableResource delegate = new VirtualFileModifiableResource();
        if (root.isFile()) {
            delegate.setFile(root);
            this.touchTimestamp(delegate);
            this.handleItemIgnoreErrors(root.getPathName());
        } else {
            List children = root.getChildrenRecursively(LeafVirtualFileFilter.INSTANCE);
            for (VirtualFile child : children) {
                String path = child.getPathNameRelativeTo(root);
                delegate.setFile(child);
                this.handleItem(delegate, path);
            }
        }
    }

    protected void handleItem(ModifiableResource resource, String name) throws IOException {
        boolean doTouch = true;
        try {
            if (handleMethod != null) {
                doTouch = (Boolean)handleMethod.invoke((Object)this, name);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        if (doTouch) {
            this.touchTimestamp(resource);
        }
        if (handleMethod == null) {
            this.handleItemIgnoreErrors(name);
        }
    }

    protected void handleItemIgnoreErrors(String name) {
        try {
            this.handleItem(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error handling item '" + name + "': " + t));
        }
    }

    private void touchTimestamp(ModifiableResource file) throws IOException {
        long lastModified = file.getLastModified();
        this.checkLastModified(lastModified);
    }

    private void checkLastModified(long lastModified) {
        if (lastModified > this.timestamp) {
            this.timestamp = lastModified;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    static {
        try {
            handleMethod = AbstractScanner.class.getDeclaredMethod("handle", String.class);
            handleMethod.setAccessible(true);
        }
        catch (Throwable t) {
            handleMethod = null;
        }
    }
}

