/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.SSLCallback;

public final class SSLQueryCallbackHandler
implements CallbackHandler {
    private final CallbackHandler delegate;
    private final Supplier<SSLSession> sslSession;
    private final AtomicBoolean once = new AtomicBoolean(true);

    public SSLQueryCallbackHandler(CallbackHandler delegate, Supplier<SSLSession> sslSession) {
        this.delegate = delegate;
        this.sslSession = Assert.checkNotNullParam("sslSession", sslSession);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        SSLSession sslSession;
        if (!this.once.compareAndSet(false, true) || (sslSession = this.sslSession.get()) == null) {
            this.delegate.handle(callbacks);
            return;
        }
        int length = callbacks.length;
        Callback[] newCallbacks = new Callback[length + 1];
        newCallbacks[0] = new SSLCallback(sslSession);
        System.arraycopy(callbacks, 0, newCallbacks, 1, length);
        try {
            this.delegate.handle(newCallbacks);
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() instanceof SSLCallback) {
                this.delegate.handle(callbacks);
                return;
            }
            throw e;
        }
    }

    void activate() {
        this.once.set(false);
    }
}

