/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;

public class HttpNamingProviderFactory
implements NamingProviderFactory {
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    @Override
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        switch (providerScheme) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    @Override
    public NamingProvider createProvider(FastHashtable<String, Object> env, URI ... providerUris) throws NamingException {
        SSLContext sslContext;
        if (providerUris.length == 0) {
            throw HttpNamingClientMessages.MESSAGES.atLeastOneUri();
        }
        URI providerUri = providerUris[0];
        AuthenticationContext captured = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(providerUri, captured, -1, "jndi", "jboss", null);
        try {
            sslContext = client.getSSLContext(providerUri, captured, "jndi", "jboss", "connect");
        }
        catch (GeneralSecurityException e) {
            throw Messages.log.failedToConfigureSslContext(e);
        }
        return new HttpNamingProvider(providerUri, env, authenticationConfiguration, sslContext);
    }
}

