/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jdbc.internal;

import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorImpl;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public class JdbcResourceLocalTransactionCoordinatorBuilderImpl
implements TransactionCoordinatorBuilder {
    public static final String SHORT_NAME = "jdbc";
    public static final JdbcResourceLocalTransactionCoordinatorBuilderImpl INSTANCE = new JdbcResourceLocalTransactionCoordinatorBuilderImpl();

    @Override
    public TransactionCoordinator buildTransactionCoordinator(TransactionCoordinatorOwner owner, TransactionCoordinatorBuilder.TransactionCoordinatorOptions options) {
        if (owner instanceof JdbcResourceTransactionAccess) {
            return new JdbcResourceLocalTransactionCoordinatorImpl(this, owner, (JdbcResourceTransactionAccess)((Object)owner));
        }
        throw new HibernateException("Could not determine ResourceLocalTransactionAccess to use in building TransactionCoordinator");
    }

    @Override
    public boolean isJta() {
        return false;
    }

    @Override
    public ConnectionReleaseMode getDefaultConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_TRANSACTION;
    }

    @Override
    public ConnectionAcquisitionMode getDefaultConnectionAcquisitionMode() {
        return ConnectionAcquisitionMode.AS_NEEDED;
    }
}

