/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="PBOX", length=5)
public interface PicketBoxLogger
extends BasicLogger {
    public static final PicketBoxLogger LOGGER = (PicketBoxLogger)Logger.getMessageLogger(PicketBoxLogger.class, (String)PicketBoxLogger.class.getPackage().getName());
    public static final PicketBoxLogger AUDIT_LOGGER = (PicketBoxLogger)Logger.getMessageLogger(PicketBoxLogger.class, (String)(PicketBoxLogger.class.getPackage().getName() + ".audit"));

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=200, value="Begin isValid, principal: %s, cache entry: %s")
    public void traceBeginIsValid(Principal var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=201, value="End isValid, result = %s")
    public void traceEndIsValid(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=202, value="Flushing all entries from security cache")
    public void traceFlushWholeCache();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=203, value="Flushing %s from security cache")
    public void traceFlushCacheEntry(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=204, value="Begin validateCache, domainInfo: %s, credential class: %s")
    public void traceBeginValidateCache(String var1, Class<?> var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=205, value="End validateCache, result = %s")
    public void traceEndValidteCache(boolean var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=206, value="Login failure")
    public void debugFailedLogin(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=207, value="updateCache, input subject: %s, cached subject: %s")
    public void traceUpdateCache(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=208, value="Inserted cache info: %s")
    public void traceInsertedCacheInfo(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=209, value="defaultLogin, principal: %s")
    public void traceDefaultLoginPrincipal(Principal var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=210, value="defaultLogin, login context: %s, subject: %s")
    public void traceDefaultLoginSubject(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=211, value="Cache entry logout failed")
    public void traceCacheEntryLogoutFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=212, value="Exception loading file %s")
    public void errorLoadingConfigFile(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=213, value="Failed to convert username to byte[] using UTF-8")
    public void errorConvertingUsernameUTF8(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=214, value="Charset %s not found. Using platform default")
    public void errorFindingCharset(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=215, value="Unsupported hash encoding format: %s")
    public void unsupportedHashEncodingFormat(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=216, value="Password hash calculation failed")
    public void errorCalculatingPasswordHash(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=217, value="Failed to check if the strong jurisdiction policy files have been installed")
    public void errorCheckingStrongJurisdictionPolicyFiles(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=218, value="bindDN is not found")
    public void traceBindDNNotFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=219, value="Exception while decrypting bindCredential")
    public void errorDecryptingBindCredential(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=220, value="Logging into LDAP server with env %s")
    public void traceLDAPConnectionEnv(Properties var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=221, value="Begin getAppConfigurationEntry(%s), size: %s")
    public void traceBeginGetAppConfigEntry(String var1, int var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=222, value="getAppConfigurationEntry(%s), no entry found, trying parent config %s")
    public void traceGetAppConfigEntryViaParent(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=223, value="getAppConfigurationEntry(%s), no entry in parent config, trying default %s")
    public void traceGetAppConfigEntryViaDefault(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=224, value="End getAppConfigurationEntry(%s), AuthInfo: %s")
    public void traceEndGetAppConfigEntryWithSuccess(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=225, value="End getAppConfigurationEntry(%s), failed to find entry")
    public void traceEndGetAppConfigEntryWithFailure(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=226, value="addAppConfig(%s), AuthInfo: %s")
    public void traceAddAppConfig(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=227, value="removeAppConfig(%s)")
    public void traceRemoveAppConfig(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=228, value="Failed to find config: %s")
    public void warnFailureToFindConfig(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=229, value="Begin loadConfig, loginConfigURL: %s")
    public void traceBeginLoadConfig(URL var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=230, value="End loadConfig, loginConfigURL: %s")
    public void traceEndLoadConfigWithSuccess(URL var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=231, value="End loadConfig, failed to load config: %s")
    public void warnEndLoadConfigWithFailure(URL var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=232, value="Try loading config as XML from %s")
    public void debugLoadConfigAsXML(URL var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=233, value="Failed to load config as XML. Try loading as Sun format from %s")
    public void debugLoadConfigAsSun(URL var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=234, value="Invalid or misspelled module option: %s")
    public void warnInvalidModuleOption(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=235, value="Error getting request from policy context")
    public void debugErrorGettingRequestFromPolicyContext(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=236, value="Begin initialize method")
    public void traceBeginInitialize();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=237, value="Saw unauthenticated indentity: %s")
    public void traceUnauthenticatedIdentity(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=238, value="Failed to create custom unauthenticated identity")
    public void warnFailureToCreateUnauthIdentity(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=239, value="End initialize method")
    public void traceEndInitialize();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=240, value="Begin login method")
    public void traceBeginLogin();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=241, value="End login method, isValid: %s")
    public void traceEndLogin(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=242, value="Begin commit method, overall result: %s")
    public void traceBeginCommit(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=243, value="Begin logout method")
    public void traceBeginLogout();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=244, value="Begin abort method, overall result: %s")
    public void traceBeginAbort(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=245, value="Found security domain: %s")
    public void traceSecurityDomainFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=246, value="The JSSE security domain %s is not valid. All authentication using this login module will fail!")
    public void errorGettingJSSESecurityDomain(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=247, value="Unable to find the security domain %s")
    public void errorFindingSecurityDomain(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=248, value="Failed to create X509CertificateVerifier")
    public void errorCreatingCertificateVerifier(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=249, value="javax.security.auth.login.password is not a X509Certificate")
    public void debugPasswordNotACertificate();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=250, value="Authenticating using unauthenticated identity %s")
    public void traceUsingUnauthIdentity(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=251, value="Failed to create identity for alias %s")
    public void debugFailureToCreateIdentityForAlias(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=252, value="Begin getAliasAndCert method")
    public void traceBeginGetAliasAndCert();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=253, value="Found certificate, serial number: %s, subject DN: %s")
    public void traceCertificateFound(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=254, value="CallbackHandler did not provide a credential")
    public void warnNullCredentialFromCallbackHandler();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=255, value="End getAliasAndCert method")
    public void traceEndGetAliasAndCert();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=256, value="Begin validateCredential method")
    public void traceBeginValidateCredential();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=257, value="Validating certificate using verifier %s")
    public void traceValidatingUsingVerifier(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=258, value="Failed to find certificate for alias &%s")
    public void warnFailureToFindCertForAlias(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=259, value="Failed to validate certificate: SecurityDomain, Keystore or certificate is null")
    public void warnFailureToValidateCertificate();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=260, value="End validateCredential method, result: %s")
    public void traceEndValidateCredential(boolean var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=261, value="Failed to load users/passwords/roles files")
    public void errorLoadingUserRolesPropertiesFiles(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=262, value="Module options [dsJndiName: %s, principalsQuery: %s, rolesQuery: %s, suspendResume: %s]")
    public void traceDBCertLoginModuleOptions(String var1, String var2, String var3, boolean var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=263, value="Executing query %s with username %s")
    public void traceExecuteQuery(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=264, value="Failed to create principal %s")
    public void debugFailureToCreatePrincipal(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=265, value="The security domain %s has been disabled. All authentication will fail")
    public void errorUsingDisabledDomain(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=266, value="Binding username %s")
    public void traceBindingLDAPUsername(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=267, value="Rejecting empty password as allowEmptyPasswords option has not been set to true")
    public void traceRejectingEmptyPassword();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=268, value="Assigning user to role %s")
    public void traceAssignUserToRole(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=269, value="Failed to parse %s as number, using default value %s")
    public void debugFailureToParseNumberProperty(String var1, long var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=270, value="Failed to query %s from %s")
    public void debugFailureToQueryLDAPAttribute(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=271, value="Logged into LDAP server, context: %s")
    public void traceSuccessfulLogInToLDAP(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=272, value="Rebind security principal to %s")
    public void traceRebindWithConfiguredPrincipal(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=273, value="Found user roles context DN: %s")
    public void traceFoundUserRolesContextDN(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=274, value="Searching rolesCtxDN %s with roleFilter: %s, filterArgs: %s, roleAttr: %s, searchScope: %s, searchTimeLimit: %s")
    public void traceRolesDNSearch(String var1, String var2, String var3, String var4, int var5, int var6);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=275, value="Checking search result %s")
    public void traceCheckSearchResult(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=276, value="Following roleDN %s")
    public void traceFollowRoleDN(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=277, value="No attribute %s found in search result %s")
    public void debugFailureToFindAttrInSearchResult(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=278, value="Failed to locate roles")
    public void debugFailureToExecuteRolesDNSearch(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=279, value="The real host for trust is %s")
    public void debugRealHostForTrust(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=280, value="Failed to load properties file %s")
    public void debugFailureToLoadPropertiesFile(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=281, value="Password hashing activated, algorithm: %s, encoding: %s, charset: %s, callback: %s, storeCallBack: %s")
    public void debugPasswordHashing(String var1, String var2, String var3, String var4, String var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=282, value="Failed to instantiate class %s")
    public void debugFailureToInstantiateClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=283, value="Bad password for username %s")
    public void debugBadPasswordForUsername(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=284, value="Created DigestCallback %s")
    public void traceCreateDigestCallback(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=285, value="Adding role %s to group %s")
    public void traceAdditionOfRoleToGroup(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=286, value="Attempting to load resource %s")
    public void traceAttemptToLoadResource(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=287, value="Failed to open properties file from URL")
    public void debugFailureToOpenPropertiesFromURL(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=288, value="Properties file %s loaded, users: %s")
    public void tracePropertiesFileLoaded(String var1, Set<?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=289, value="JACC delegate access denied [permission: %s, caller: %s, roles: %s")
    public void debugJACCDeniedAccess(String var1, Subject var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=290, value="No method permissions assigned to method: %s, interface: %s")
    public void traceNoMethodPermissions(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=291, value="Method: %s, interface: %s, required roles: %s")
    public void debugEJBPolicyModuleDelegateState(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=292, value="Insufficient method permissions [principal: %s, EJB name: %s, method: %s, interface: %s, required roles: %s, principal roles: %s, run-as roles: %s]")
    public void debugInsufficientMethodPermissions(Principal var1, String var2, String var3, String var4, String var5, String var6, String var7);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=293, value="Exception caught")
    public void debugIgnoredException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=294, value="Check is not resourcePerm, userDataPerm or roleRefPerm")
    public void debugInvalidWebJaccCheck();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=295, value="hasResourcePermission, permission: %s, allowed: %s")
    public void traceHasResourcePermission(String var1, boolean var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=296, value="hasRolePermission, permission: %s, allowed: %s")
    public void traceHasRolePermission(String var1, boolean var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=297, value="hasUserDataPermission, permission: %s, allowed: %s")
    public void traceHasUserDataPermission(String var1, boolean var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=298, value="Requisite module %s failed")
    public void debugRequisiteModuleFailure(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=299, value="Required module %s failed")
    public void debugRequiredModuleFailure(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=300, value="Denied: matched excluded set, permission %s")
    public void traceImpliesMatchesExcludedSet(Permission var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=301, value="Allowed: matched unchecked set, permission %s")
    public void traceImpliesMatchesUncheckedSet(Permission var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=302, value="Protection domain principals: %s")
    public void traceProtectionDomainPrincipals(List<String> var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=303, value="Not principals found in protection domain %s")
    public void traceNoPrincipalsInProtectionDomain(ProtectionDomain var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=304, value="Checking role: %s, permissions: %s")
    public void debugImpliesParameters(String var1, Permissions var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=305, value="Checking result, implies: %s")
    public void debugImpliesResult(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=306, value="No PolicyContext found for contextID %s")
    public void traceNoPolicyContextForId(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=307, value="Constructing JBossPolicyConfiguration with contextID %s")
    public void debugJBossPolicyConfigurationConstruction(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=308, value="addToExcludedPolicy, permission: %s")
    public void traceAddPermissionToExcludedPolicy(Permission var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=309, value="addToExcludedPolicy, permission collection: %s")
    public void traceAddPermissionsToExcludedPolicy(PermissionCollection var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=310, value="addToRole, permission: %s")
    public void traceAddPermissionToRole(Permission var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=311, value="addToRole, permission collection: %s")
    public void traceAddPermissionsToRole(PermissionCollection var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=312, value="addToUncheckedPolicy, permission: %s")
    public void traceAddPermissionToUncheckedPolicy(Permission var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=313, value="addToUncheckedPolicy, permission collection: %s")
    public void traceAddPermissionsToUncheckedPolicy(PermissionCollection var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=314, value="commit, contextID: %s")
    public void tracePolicyConfigurationCommit(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=315, value="delete, contextID: %s")
    public void tracePolicyConfigurationDelete(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=316, value="linkConfiguration, link to contextID: %s")
    public void traceLinkConfiguration(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=317, value="removeExcludedPolicy, contextID: %s")
    public void traceRemoveExcludedPolicy(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=318, value="removeRole, role name: %s, contextID: %s")
    public void traceRemoveRole(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=319, value="removeUncheckedPolicy, contextID: %s")
    public void traceRemoveUncheckedPolicy(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=320, value="Mapped X500 principal, new principal: %s")
    public void traceMappedX500Principal(Principal var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=321, value="Query returned an empty result")
    public void traceQueryWithEmptyResult();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=322, value="Mapping provider options [principal: %s, principal to roles map: %s, subject principals: %s]")
    public void debugMappingProviderOptions(Principal var1, Map<String, Set<String>> var2, Set<Principal> var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=323, value="No audit context found for security domain %s; using default context")
    public void traceNoAuditContextFoundForDomain(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=324, value="AuthorizationManager is null for security domain %s")
    public void debugNullAuthorizationManager(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=325, value="Authorization processing error")
    public void debugAuthorizationError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=326, value="%s processing failed")
    public void debugFailureExecutingMethod(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=327, value="Returning host %s from thread [id: %s]")
    public void traceHostThreadLocalGet(String var1, long var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=328, value="Setting host %s on thread [id: %s]")
    public void traceHostThreadLocalSet(String var1, long var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=329, value="Begin doesUserHaveRole, principal: %s, roles: %s")
    public void traceBeginDoesUserHaveRole(Principal var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=330, value="End doesUserHaveRole, result: %s")
    public void traceEndDoesUserHaveRole(boolean var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=331, value="Roles before mapping: %s")
    public void traceRolesBeforeMapping(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=332, value="Roles after mapping: %s")
    public void traceRolesAfterMapping(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=333, value="Deregistered policy for contextID: %s, type: %s")
    public void traceDeregisterPolicy(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=334, value="Registered policy for contextID: %s, type: %s, location: %s")
    public void traceRegisterPolicy(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=335, value="SecurityManagement is not set, creating a default one")
    public void warnSecurityMagementNotSet();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=336, value="AuthenticationManager is null for security domain %s")
    public void debugNullAuthenticationManager(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=337, value="nextState for action %s: %s")
    public void traceStateMachineNextState(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=338, value="Ignore attribute [uri: %s, qname: %s, value: %s]")
    public void traceIgnoreXMLAttribute(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=339, value="systemId argument '%s' for publicId '%s' is different from the registered systemId '%s', resolution will be based on the argument")
    public void traceSystemIDMismatch(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=340, value="Cannot resolve entity, systemId: %s, publicId: %s")
    public void debugFailureToResolveEntity(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=341, value="Begin resolvePublicId, publicId: %s")
    public void traceBeginResolvePublicID(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=342, value="Found entity from %s: %s, filename: %s")
    public void traceFoundEntityFromID(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=343, value="Cannot load %s from %s resource: %s")
    public void warnFailureToLoadIDFromResource(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=344, value="Begin resolveSystemId, systemId: %s")
    public void traceBeginResolveSystemID(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=345, value="Begin resolveSystemIdasURL, systemId: %s")
    public void traceBeginResolveSystemIDasURL(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=346, value="Trying to resolve systemId %s as a non-file URL")
    public void warnResolvingSystemIdAsNonFileURL(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=347, value="Begin resolveClasspathName, systemId: %s")
    public void traceBeginResolveClasspathName(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=348, value="Mapped systemId to filename %s")
    public void traceMappedSystemIdToFilename(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=349, value="Mapped resource %s to URL %s")
    public void traceMappedResourceToURL(String var1, URL var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=350, value="Module option: %s, value: %s")
    public void debugModuleOption(String var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=351, value="Obtained auth info from handler, principal: %s, credential class: %s")
    public void traceObtainedAuthInfoFromHandler(Principal var1, Class<?> var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=352, value="JSSE domain got request for key with alias %s")
    public void traceJSSEDomainGetKey(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=353, value="JSSE domain got request for certificate with alias %s")
    public void traceJSSEDomainGetCertificate(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=354, value="Setting security roles ThreadLocal: %s")
    public void traceSecRolesAssociationSetSecurityRoles(Map<String, Set<String>> var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=355, value="Begin execPasswordCmd, command: %s")
    public void traceBeginExecPasswordCmd(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=356, value="End execPasswordCmd, exit code: %s")
    public void traceEndExecPasswordCmd(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=357, value="Begin getIdentity, username: %s")
    public void traceBeginGetIdentity(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=358, value="Begin getRoleSets")
    public void traceBeginGetRoleSets();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=359, value="Current calling principal: %s, thread name: %s")
    public void traceCurrentCallingPrincipal(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=360, value="Creating login module with empty password")
    public void warnModuleCreationWithEmptyPassword();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=361, value="Default Security Vault Implementation Initialized and Ready")
    public void infoVaultInitialized();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=362, value="Cannot get MD5 algorithm instance for hashing password commands. Using NULL.")
    public void errorCannotGetMD5AlgorithmInstance();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=363, value="Retrieving password from the cache for key: %s")
    public void traceRetrievingPasswordFromCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=364, value="Storing password to the cache for key: %s")
    public void traceStoringPasswordToCache(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=365, value="Resetting cache")
    public void traceResettingCache();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=366, value="Error parsing time out number.")
    public void errorParsingTimeoutNumber();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=367, value="Reading security vault data version %s target version is %s")
    public void securityVaultContentVersion(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=368, value="Security Vault contains both covnerted (%s) and pre-conversion data (%s). Try to delete %s file and start over again.")
    public void mixedVaultDataFound(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=369, value="Ambiguos vault block and attribute name stored in original security vault. Delimiter (%s) is part of vault block or attribute name. Took the first delimiter. Result vault block (%s) attribute name (%s). Modify security vault manually.")
    public void ambiguosKeyForSecurityVaultTransformation(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=370, value="Cannot delete original security vault file (%s). Delete the file manually before next start, please.")
    public void cannotDeleteOriginalVaultFile(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=371, value="Security Vault does not contain SecretKey entry under alias (%s)")
    public void vaultDoesnotContainSecretKey(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=372, value="Security Vault key store successfuly converted to JCEKS type (%s). From now on use JCEKS as KEYSTORE_TYPE in Security Vault configuration.")
    public void keyStoreConvertedToJCEKS(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=373, value="Error getting ServerAuthConfig for layer %s and appContext %s")
    public void errorGettingServerAuthConfig(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=374, value="Error getting ServerAuthContext for authContextId %s and security domain %s")
    public void errorGettingServerAuthContext(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=375, value="Error getting the module classloader informations for cache")
    public void errorGettingModuleInformation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=376, value="Wrong Base64 string used with masked password utility. Following is correct (%s)")
    public void wrongBase64StringUsed(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=377, value="JAAS logout, login context: %s, subject: %s")
    public void traceLogoutSubject(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=378, value="Problem when closing original LDAP context during role search rebind. Trying to create new LDAP context.")
    public void warnProblemClosingOriginalLdapContextDuringRebind(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=379, value="Password validation failed")
    public void passwordValidationFailed(@Cause Throwable var1);
}

