/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueFloat
extends Value {
    public static final int ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    private static final ValueFloat ZERO = new ValueFloat(0.0f);
    private static final ValueFloat ONE = new ValueFloat(1.0f);
    private final float value;

    private ValueFloat(float value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value + v2.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value - v2.value);
    }

    @Override
    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value * v2.value);
    }

    @Override
    public Value divide(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        if ((double)v2.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / v2.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueFloat other = (ValueFloat)v;
        if (other.value == 0.0f) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value % other.value);
    }

    @Override
    public String getSQL() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueFloat v = (ValueFloat)o;
        return Float.compare(this.value, v.value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 7L;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int hashCode() {
        long hash = Float.floatToIntBits(this.value);
        return (int)(hash ^ hash >> 32);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setFloat(parameterIndex, this.value);
    }

    public static ValueFloat get(float d) {
        if (d == 1.0f) {
            return ONE;
        }
        if (d == 0.0f) {
            return ZERO;
        }
        return (ValueFloat)Value.cache(new ValueFloat(d));
    }

    @Override
    public int getDisplaySize() {
        return 15;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueFloat)) {
            return false;
        }
        return this.compareSecure((ValueFloat)other, null) == 0;
    }
}

