/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import org.h2.message.DbException;
import org.h2.util.HashBase;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap<V>
extends HashBase {
    private Value[] keys;
    private V[] values;

    public static <T> ValueHashMap<T> newInstance() {
        return new ValueHashMap();
    }

    @Override
    protected void reset(int newLevel) {
        super.reset(newLevel);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    @Override
    protected void rehash(int newLevel) {
        Value[] oldKeys = this.keys;
        V[] oldValues = this.values;
        this.reset(newLevel);
        int len = oldKeys.length;
        for (int i = 0; i < len; ++i) {
            Value k = oldKeys[i];
            if (k == null || k == ValueNull.DELETED) continue;
            this.internalPut(k, oldValues[i]);
        }
    }

    private int getIndex(Value key) {
        return key.hashCode() & this.mask;
    }

    public void put(Value key, V value) {
        this.checkSizePut();
        this.internalPut(key, value);
    }

    private void internalPut(Value key, V value) {
        int index = this.getIndex(key);
        int plus = 1;
        int deleted = -1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                if (deleted >= 0) {
                    index = deleted;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[index] = key;
                this.values[index] = value;
                return;
            }
            if (k == ValueNull.DELETED) {
                if (deleted < 0) {
                    deleted = index;
                }
            } else if (k.equals(key)) {
                this.values[index] = value;
                return;
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        DbException.throwInternalError("hashmap is full");
    }

    public void remove(Value key) {
        this.checkSizeRemove();
        int index = this.getIndex(key);
        int plus = 1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                return;
            }
            if (k != ValueNull.DELETED && k.equals(key)) {
                this.keys[index] = ValueNull.DELETED;
                this.values[index] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
    }

    public V get(Value key) {
        int index = this.getIndex(key);
        int plus = 1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                return null;
            }
            if (k != ValueNull.DELETED && k.equals(key)) {
                return this.values[index];
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        return null;
    }

    public ArrayList<Value> keys() {
        ArrayList<Value> list = New.arrayList(this.size);
        for (Value k : this.keys) {
            if (k == null || k == ValueNull.DELETED) continue;
            list.add(k);
        }
        return list;
    }

    public ArrayList<V> values() {
        ArrayList list = New.arrayList(this.size);
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            Value k = this.keys[i];
            if (k == null || k == ValueNull.DELETED) continue;
            list.add(this.values[i]);
        }
        return list;
    }
}

