/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.New;

public class TempFileDeleter {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<PhantomReference<?>, String> refMap = New.hashMap();

    private TempFileDeleter() {
    }

    public static TempFileDeleter getInstance() {
        return new TempFileDeleter();
    }

    public synchronized Reference<?> addFile(String fileName, Object file) {
        IOUtils.trace("TempFileDeleter.addFile", fileName, file);
        PhantomReference<Object> ref = new PhantomReference<Object>(file, this.queue);
        this.refMap.put(ref, fileName);
        this.deleteUnused();
        return ref;
    }

    public synchronized void deleteFile(Reference<?> ref, String fileName) {
        String f2;
        if (ref != null && (f2 = this.refMap.remove(ref)) != null) {
            if (SysProperties.CHECK && fileName != null && !f2.equals(fileName)) {
                DbException.throwInternalError("f2:" + f2 + " f:" + fileName);
            }
            fileName = f2;
        }
        if (fileName != null && FileUtils.exists(fileName)) {
            try {
                IOUtils.trace("TempFileDeleter.deleteFile", fileName, null);
                FileUtils.tryDelete(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAll() {
        for (String tempFile : New.arrayList(this.refMap.values())) {
            this.deleteFile(null, tempFile);
        }
        this.deleteUnused();
    }

    public void deleteUnused() {
        Reference<Object> ref;
        while (this.queue != null && (ref = this.queue.poll()) != null) {
            this.deleteFile(ref, null);
        }
    }

    public void stopAutoDelete(Reference<?> ref, String fileName) {
        IOUtils.trace("TempFileDeleter.stopAutoDelete", fileName, ref);
        if (ref != null) {
            String f2 = this.refMap.remove(ref);
            if (SysProperties.CHECK && (f2 == null || !f2.equals(fileName))) {
                DbException.throwInternalError("f2:" + f2 + " " + (f2 == null ? "" : f2) + " f:" + fileName);
            }
        }
        this.deleteUnused();
    }
}

