/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBase;

class FileDisk
extends FileBase {
    private final RandomAccessFile file;
    private final String name;
    private final boolean readOnly;

    FileDisk(String fileName, String mode) throws FileNotFoundException {
        this.file = new RandomAccessFile(fileName, mode);
        this.name = fileName;
        this.readOnly = mode.equals("r");
    }

    @Override
    public void force(boolean metaData) throws IOException {
        String m = SysProperties.SYNC_METHOD;
        if (!"".equals(m)) {
            if ("sync".equals(m)) {
                this.file.getFD().sync();
            } else if ("force".equals(m)) {
                this.file.getChannel().force(true);
            } else if ("forceFalse".equals(m)) {
                this.file.getChannel().force(false);
            } else {
                this.file.getFD().sync();
            }
        }
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (newLength < this.file.length()) {
            this.file.setLength(newLength);
        }
        return this;
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.file.getChannel().tryLock(position, size, shared);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.file.close();
    }

    @Override
    public long position() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long size() throws IOException {
        return this.file.length();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int len = this.file.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
        if (len > 0) {
            dst.position(dst.position() + len);
        }
        return len;
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        this.file.seek(pos);
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this.file.write(src.array(), src.arrayOffset() + src.position(), len);
        src.position(src.position() + len);
        return len;
    }

    public String toString() {
        return this.name;
    }
}

