/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;

public class Cursor<K, V>
implements Iterator<K> {
    private final MVMap<K, ?> map;
    private final K from;
    private CursorPos pos;
    private K current;
    private K last;
    private V currentValue;
    private V lastValue;
    private Page lastPage;
    private final Page root;
    private boolean initialized;

    Cursor(MVMap<K, ?> map, Page root, K from) {
        this.map = map;
        this.root = root;
        this.from = from;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.min(this.root, this.from);
            this.initialized = true;
            this.fetchNext();
        }
        return this.current != null;
    }

    @Override
    public K next() {
        this.hasNext();
        K c = this.current;
        this.last = this.current;
        this.lastValue = this.currentValue;
        this.lastPage = this.pos == null ? null : this.pos.page;
        this.fetchNext();
        return c;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page getPage() {
        return this.lastPage;
    }

    public void skip(long n) {
        if (!this.hasNext()) {
            return;
        }
        if (n < 10L) {
            while (n-- > 0L) {
                this.fetchNext();
            }
            return;
        }
        long index = this.map.getKeyIndex(this.current);
        K k = this.map.getKey(index + n);
        this.pos = null;
        this.min(this.root, k);
        this.fetchNext();
    }

    @Override
    public void remove() {
        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
    }

    private void min(Page p, K from) {
        int x;
        while (true) {
            if (p.isLeaf()) {
                int n = x = from == null ? 0 : p.binarySearch(from);
                if (x < 0) {
                    x = -x - 1;
                }
                break;
            }
            int n = x = from == null ? -1 : p.binarySearch(from);
            x = x < 0 ? -x - 1 : ++x;
            this.pos = new CursorPos(p, x + 1, this.pos);
            p = p.getChildPage(x);
        }
        this.pos = new CursorPos(p, x, this.pos);
    }

    private void fetchNext() {
        while (this.pos != null) {
            if (this.pos.index < this.pos.page.getKeyCount()) {
                int index = this.pos.index++;
                this.current = this.pos.page.getKey(index);
                this.currentValue = this.pos.page.getValue(index);
                return;
            }
            this.pos = this.pos.parent;
            if (this.pos == null) break;
            if (this.pos.index >= this.map.getChildPageCount(this.pos.page)) continue;
            this.min(this.pos.page.getChildPage(this.pos.index++), null);
        }
        this.current = null;
    }
}

