/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.api.ErrorCode;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcSQLException;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Properties MESSAGES = new Properties();
    private Object source;

    private DbException(SQLException e) {
        super(e.getMessage(), e);
    }

    private static String translate(String key, String ... params) {
        String message = null;
        if (MESSAGES != null) {
            message = MESSAGES.getProperty(key);
        }
        if (message == null) {
            message = "(Message " + key + " not found)";
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String s = params[i];
                if (s == null || s.length() <= 0) continue;
                params[i] = StringUtils.quoteIdentifier(s);
            }
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    public SQLException getSQLException() {
        return (SQLException)this.getCause();
    }

    public int getErrorCode() {
        return this.getSQLException().getErrorCode();
    }

    public DbException addSQL(String sql) {
        SQLException e = this.getSQLException();
        if (e instanceof JdbcSQLException) {
            JdbcSQLException j = (JdbcSQLException)e;
            if (j.getSQL() == null) {
                j.setSQL(sql);
            }
            return this;
        }
        e = new JdbcSQLException(e.getMessage(), sql, e.getSQLState(), e.getErrorCode(), e, null);
        return new DbException(e);
    }

    public static DbException get(int errorCode) {
        return DbException.get(errorCode, (String)null);
    }

    public static DbException get(int errorCode, String p1) {
        return DbException.get(errorCode, new String[]{p1});
    }

    public static DbException get(int errorCode, Throwable cause, String ... params) {
        return new DbException(DbException.getJdbcSQLException(errorCode, cause, params));
    }

    public static DbException get(int errorCode, String ... params) {
        return new DbException(DbException.getJdbcSQLException(errorCode, null, params));
    }

    public static DbException getSyntaxError(String sql, int index) {
        sql = StringUtils.addAsterisk(sql, index);
        return DbException.get(42000, sql);
    }

    public static DbException getSyntaxError(String sql, int index, String message) {
        sql = StringUtils.addAsterisk(sql, index);
        return new DbException(DbException.getJdbcSQLException(42001, null, sql, message));
    }

    public static DbException getUnsupportedException(String message) {
        return DbException.get(50100, message);
    }

    public static DbException getInvalidValueException(String param, Object value) {
        return DbException.get(90008, value == null ? "null" : value.toString(), param);
    }

    public static RuntimeException throwInternalError(String s) {
        RuntimeException e = new RuntimeException(s);
        DbException.traceThrowable(e);
        throw e;
    }

    public static RuntimeException throwInternalError() {
        return DbException.throwInternalError("Unexpected code path");
    }

    public static SQLException toSQLException(Exception e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return DbException.convert(e).getSQLException();
    }

    public static DbException convert(Throwable e) {
        if (e instanceof DbException) {
            return (DbException)e;
        }
        if (e instanceof SQLException) {
            return new DbException((SQLException)e);
        }
        if (e instanceof InvocationTargetException) {
            return DbException.convertInvocation((InvocationTargetException)e, null);
        }
        if (e instanceof IOException) {
            return DbException.get(90028, e, e.toString());
        }
        if (e instanceof OutOfMemoryError) {
            return DbException.get(90108, e, new String[0]);
        }
        if (e instanceof StackOverflowError || e instanceof LinkageError) {
            return DbException.get(50000, e, e.toString());
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return DbException.get(50000, e, e.toString());
    }

    public static DbException convertInvocation(InvocationTargetException te, String message) {
        Throwable t = te.getTargetException();
        if (t instanceof SQLException || t instanceof DbException) {
            return DbException.convert(t);
        }
        message = message == null ? t.getMessage() : message + ": " + t.getMessage();
        return DbException.get(90105, t, message);
    }

    public static DbException convertIOException(IOException e, String message) {
        if (message == null) {
            Throwable t = e.getCause();
            if (t instanceof DbException) {
                return (DbException)t;
            }
            return DbException.get(90028, e, e.toString());
        }
        return DbException.get(90031, e, e.toString(), message);
    }

    private static JdbcSQLException getJdbcSQLException(int errorCode, Throwable cause, String ... params) {
        String sqlstate = ErrorCode.getState(errorCode);
        String message = DbException.translate(sqlstate, params);
        return new JdbcSQLException(message, null, sqlstate, errorCode, cause, null);
    }

    public static IOException convertToIOException(Throwable e) {
        JdbcSQLException e2;
        if (e instanceof IOException) {
            return (IOException)e;
        }
        if (e instanceof JdbcSQLException && (e2 = (JdbcSQLException)e).getOriginalCause() != null) {
            e = e2.getOriginalCause();
        }
        return new IOException(e.toString(), e);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public static void traceThrowable(Throwable e) {
        PrintWriter writer = DriverManager.getLogWriter();
        if (writer != null) {
            e.printStackTrace(writer);
        }
    }

    static {
        try {
            byte[] translations;
            String language;
            byte[] messages = Utils.getResource("/org/h2/res/_messages_en.prop");
            if (messages != null) {
                MESSAGES.load(new ByteArrayInputStream(messages));
            }
            if (!"en".equals(language = Locale.getDefault().getLanguage()) && (translations = Utils.getResource("/org/h2/res/_messages_" + language + ".prop")) != null) {
                SortedProperties p = SortedProperties.fromLines(new String(translations, Constants.UTF8));
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String key = (String)e.getKey();
                    String translation = (String)e.getValue();
                    if (translation == null || translation.startsWith("#")) continue;
                    String original = MESSAGES.getProperty(key);
                    String message = translation + "\n" + original;
                    MESSAGES.put(key, message);
                }
            }
        }
        catch (OutOfMemoryError e) {
            DbException.traceThrowable(e);
        }
        catch (IOException e) {
            DbException.traceThrowable(e);
        }
    }
}

