/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.h2.jdbcx.JdbcConnectionPoolBackwardsCompat;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.DbException;
import org.h2.util.New;

public class JdbcConnectionPool
implements DataSource,
ConnectionEventListener,
JdbcConnectionPoolBackwardsCompat {
    private static final int DEFAULT_TIMEOUT = 30;
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private final ConnectionPoolDataSource dataSource;
    private final ArrayList<PooledConnection> recycledConnections = New.arrayList();
    private PrintWriter logWriter;
    private int maxConnections = 10;
    private int timeout = 30;
    private int activeConnections;
    private boolean isDisposed;

    protected JdbcConnectionPool(ConnectionPoolDataSource dataSource) {
        this.dataSource = dataSource;
        if (dataSource != null) {
            try {
                this.logWriter = dataSource.getLogWriter();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static JdbcConnectionPool create(ConnectionPoolDataSource dataSource) {
        return new JdbcConnectionPool(dataSource);
    }

    public static JdbcConnectionPool create(String url, String user, String password) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(url);
        ds.setUser(user);
        ds.setPassword(password);
        return new JdbcConnectionPool(ds);
    }

    public synchronized void setMaxConnections(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Invalid maxConnections value: " + max);
        }
        this.maxConnections = max;
        this.notifyAll();
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.timeout;
    }

    @Override
    public synchronized void setLoginTimeout(int seconds) {
        if (seconds == 0) {
            seconds = 30;
        }
        this.timeout = seconds;
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        ArrayList<PooledConnection> list = this.recycledConnections;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.closeConnection(list.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        long max = System.currentTimeMillis() + (long)(this.timeout * 1000);
        do {
            JdbcConnectionPool jdbcConnectionPool = this;
            synchronized (jdbcConnectionPool) {
                if (this.activeConnections < this.maxConnections) {
                    return this.getConnectionNow();
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (System.currentTimeMillis() <= max);
        throw new SQLException("Login timeout", "08001", 8001);
    }

    @Override
    public Connection getConnection(String user, String password) {
        throw new UnsupportedOperationException();
    }

    private Connection getConnectionNow() throws SQLException {
        if (this.isDisposed) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        PooledConnection pc = !this.recycledConnections.isEmpty() ? this.recycledConnections.remove(this.recycledConnections.size() - 1) : this.dataSource.getPooledConnection();
        Connection conn = pc.getConnection();
        ++this.activeConnections;
        pc.addConnectionEventListener(this);
        return conn;
    }

    synchronized void recycleConnection(PooledConnection pc) {
        if (this.activeConnections <= 0) {
            throw new AssertionError();
        }
        --this.activeConnections;
        if (!this.isDisposed && this.activeConnections < this.maxConnections) {
            this.recycledConnections.add(pc);
        } else {
            this.closeConnection(pc);
        }
        if (this.activeConnections >= this.maxConnections - 1) {
            this.notifyAll();
        }
    }

    private void closeConnection(PooledConnection pc) {
        block2: {
            try {
                pc.close();
            }
            catch (SQLException e) {
                if (this.logWriter == null) break block2;
                e.printStackTrace(this.logWriter);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        pc.removeConnectionEventListener(this);
        this.recycleConnection(pc);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
    }

    public synchronized int getActiveConnections() {
        return this.activeConnections;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw DbException.getUnsupportedException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw DbException.getUnsupportedException("isWrapperFor");
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

