/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.PageData;
import org.h2.index.PageDataCursor;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.value.Value;

public class PageDataLeaf
extends PageData {
    private final boolean optimizeUpdate;
    private int[] offsets;
    private Row[] rows;
    private SoftReference<Row> rowRef;
    private int firstOverflowPageId;
    private int start;
    private int overflowRowSize;
    private int columnCount;
    private int memoryData;
    private boolean writtenData;

    private PageDataLeaf(PageDataIndex index, int pageId, Data data) {
        super(index, pageId, data);
        this.optimizeUpdate = index.getDatabase().getSettings().optimizeUpdate;
    }

    static PageDataLeaf create(PageDataIndex index, int pageId, int parentPageId) {
        PageDataLeaf p = new PageDataLeaf(index, pageId, index.getPageStore().createData());
        index.getPageStore().logUndo(p, null);
        p.rows = Row.EMPTY_ARRAY;
        p.parentPageId = parentPageId;
        p.columnCount = index.getTable().getColumns().length;
        p.writeHead();
        p.start = p.data.length();
        return p;
    }

    public static Page read(PageDataIndex index, Data data, int pageId) {
        PageDataLeaf p = new PageDataLeaf(index, pageId, data);
        p.read();
        return p;
    }

    private void read() {
        this.data.reset();
        byte type = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        int tableId = this.data.readVarInt();
        if (tableId != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected table:" + this.index.getId() + " got:" + tableId + " type:" + type);
        }
        this.columnCount = this.data.readVarInt();
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.keys = new long[this.entryCount];
        this.rows = new Row[this.entryCount];
        if (type == 1) {
            if (this.entryCount != 1) {
                DbException.throwInternalError("entries: " + this.entryCount);
            }
            this.firstOverflowPageId = this.data.readInt();
        }
        for (int i = 0; i < this.entryCount; ++i) {
            this.keys[i] = this.data.readVarLong();
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.writtenData = true;
    }

    private int getRowLength(Row row) {
        int size = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            size += this.data.getValueLen(row.getValue(i));
        }
        return size;
    }

    private int findInsertionPoint(long key) {
        int x = this.find(key);
        if (x < this.entryCount && this.keys[x] == key) {
            throw this.index.getDuplicateKeyException("" + key);
        }
        return x;
    }

    @Override
    int addRowTry(Row row) {
        int x;
        this.index.getPageStore().logUndo(this, this.data);
        int rowLength = this.getRowLength(row);
        int pageSize = this.index.getPageStore().getPageSize();
        int last = this.entryCount == 0 ? pageSize : this.offsets[this.entryCount - 1];
        int keyOffsetPairLen = 2 + Data.getVarLongLen(row.getKey());
        if (this.entryCount > 0 && last - rowLength < this.start + keyOffsetPairLen) {
            int x2 = this.findInsertionPoint(row.getKey());
            if (this.entryCount > 1) {
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                if (this.index.isSortedInsertMode()) {
                    return x2 < 2 ? 1 : (x2 > this.entryCount - 1 ? this.entryCount - 1 : x2);
                }
                int third = this.entryCount / 3;
                return x2 < third ? third : (x2 >= 2 * third ? 2 * third : x2);
            }
            return x2;
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 0) {
            x = 0;
        } else {
            if (!this.optimizeUpdate) {
                this.readAllRows();
            }
            x = this.findInsertionPoint(row.getKey());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        last = x == 0 ? pageSize : this.offsets[x - 1];
        int offset = last - rowLength;
        this.start += keyOffsetPairLen;
        this.offsets = PageDataLeaf.insert(this.offsets, this.entryCount, x, offset);
        PageDataLeaf.add(this.offsets, x + 1, this.entryCount + 1, -rowLength);
        this.keys = PageDataLeaf.insert(this.keys, this.entryCount, x, row.getKey());
        this.rows = PageDataLeaf.insert(this.rows, this.entryCount, x, row);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        if (this.optimizeUpdate && this.writtenData && offset >= this.start) {
            byte[] d = this.data.getBytes();
            int dataStart = this.offsets[this.entryCount - 1] + rowLength;
            int dataEnd = this.offsets[x];
            System.arraycopy(d, dataStart, d, dataStart - rowLength, dataEnd - dataStart + rowLength);
            this.data.setPos(dataEnd);
            for (int j = 0; j < this.columnCount; ++j) {
                this.data.writeValue(row.getValue(j));
            }
        }
        if (offset < this.start) {
            int size;
            int page;
            this.writtenData = false;
            if (this.entryCount > 1) {
                DbException.throwInternalError();
            }
            this.start += 4;
            int remaining = rowLength - (pageSize - this.start);
            this.offsets[x] = offset = this.start;
            int previous = this.getPos();
            int dataOffset = pageSize;
            this.firstOverflowPageId = page = this.index.getPageStore().allocatePage();
            this.overflowRowSize = pageSize + rowLength;
            this.writeData();
            Row r = this.rows[0];
            this.rowRef = new SoftReference<Row>(r);
            this.rows[0] = null;
            Data all = this.index.getPageStore().createData();
            all.checkCapacity(this.data.length());
            all.write(this.data.getBytes(), 0, this.data.length());
            this.data.truncate(this.index.getPageStore().getPageSize());
            do {
                int next;
                int type;
                if (remaining <= pageSize - 9) {
                    type = 19;
                    size = remaining;
                    next = 0;
                } else {
                    type = 3;
                    size = pageSize - 11;
                    next = this.index.getPageStore().allocatePage();
                }
                PageDataOverflow overflow = PageDataOverflow.create(this.index.getPageStore(), page, type, previous, next, all, dataOffset, size);
                this.index.getPageStore().update(overflow);
                dataOffset += size;
                previous = page;
                page = next;
            } while ((remaining -= size) > 0);
        }
        if (this.rowRef == null) {
            this.memoryChange(true, row);
        } else {
            this.memoryChange(true, null);
        }
        return -1;
    }

    private void removeRow(int i) {
        Row r;
        this.index.getPageStore().logUndo(this, this.data);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        if ((r = this.getRowAt(i)) != null) {
            this.memoryChange(false, r);
        }
        --this.entryCount;
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.firstOverflowPageId != 0) {
            this.start -= 4;
            this.freeOverflow();
            this.firstOverflowPageId = 0;
            this.overflowRowSize = 0;
            this.rowRef = null;
        }
        int keyOffsetPairLen = 2 + Data.getVarLongLen(this.keys[i]);
        int startNext = i > 0 ? this.offsets[i - 1] : this.index.getPageStore().getPageSize();
        int rowLength = startNext - this.offsets[i];
        if (this.optimizeUpdate) {
            if (this.writtenData) {
                byte[] d = this.data.getBytes();
                int dataStart = this.offsets[this.entryCount];
                System.arraycopy(d, dataStart, d, dataStart + rowLength, this.offsets[i] - dataStart);
                Arrays.fill(d, dataStart, dataStart + rowLength, (byte)0);
            }
        } else {
            int clearStart = this.offsets[this.entryCount];
            Arrays.fill(this.data.getBytes(), clearStart, clearStart + rowLength, (byte)0);
        }
        this.start -= keyOffsetPairLen;
        this.offsets = PageDataLeaf.remove(this.offsets, this.entryCount + 1, i);
        PageDataLeaf.add(this.offsets, i, this.entryCount, rowLength);
        this.keys = PageDataLeaf.remove(this.keys, this.entryCount + 1, i);
        this.rows = PageDataLeaf.remove(this.rows, this.entryCount + 1, i);
    }

    @Override
    Cursor find(Session session, long minKey, long maxKey, boolean multiVersion) {
        int x = this.find(minKey);
        return new PageDataCursor(session, this, x, maxKey, multiVersion);
    }

    Row getRowAt(int at) {
        Row r = this.rows[at];
        if (r == null) {
            if (this.firstOverflowPageId == 0) {
                r = this.readRow(this.data, this.offsets[at], this.columnCount);
            } else {
                PageDataOverflow page;
                if (this.rowRef != null && (r = this.rowRef.get()) != null) {
                    return r;
                }
                PageStore store = this.index.getPageStore();
                Data buff = store.createData();
                int pageSize = store.getPageSize();
                int offset = this.offsets[at];
                buff.write(this.data.getBytes(), offset, pageSize - offset);
                int next = this.firstOverflowPageId;
                while ((next = (page = this.index.getPageOverflow(next)).readInto(buff)) != 0) {
                }
                this.overflowRowSize = pageSize + buff.length();
                r = this.readRow(buff, 0, this.columnCount);
            }
            r.setKey(this.keys[at]);
            if (this.firstOverflowPageId != 0) {
                this.rowRef = new SoftReference<Row>(r);
            } else {
                this.rows[at] = r;
                this.memoryChange(true, r);
            }
        }
        return r;
    }

    int getEntryCount() {
        return this.entryCount;
    }

    @Override
    PageData split(int splitPoint) {
        int newPageId = this.index.getPageStore().allocatePage();
        PageDataLeaf p2 = PageDataLeaf.create(this.index, newPageId, this.parentPageId);
        int i = splitPoint;
        while (i < this.entryCount) {
            int split = p2.addRowTry(this.getRowAt(splitPoint));
            if (split != -1) {
                DbException.throwInternalError("split " + split);
            }
            this.removeRow(splitPoint);
        }
        return p2;
    }

    @Override
    long getLastKey() {
        if (this.entryCount == 0) {
            return 0L;
        }
        return this.getRowAt(this.entryCount - 1).getKey();
    }

    PageDataLeaf getNextPage() {
        if (this.parentPageId == 0) {
            return null;
        }
        PageDataNode next = (PageDataNode)this.index.getPage(this.parentPageId, -1);
        return next.getNextPage(this.keys[this.entryCount - 1]);
    }

    @Override
    PageDataLeaf getFirstLeaf() {
        return this;
    }

    @Override
    protected void remapChildren(int old) {
        if (this.firstOverflowPageId == 0) {
            return;
        }
        PageDataOverflow overflow = this.index.getPageOverflow(this.firstOverflowPageId);
        overflow.setParentPageId(this.getPos());
        this.index.getPageStore().update(overflow);
    }

    @Override
    boolean remove(long key) {
        int i = this.find(key);
        if (this.keys == null || this.keys[i] != key) {
            throw DbException.get(90112, this.index.getSQL() + ": " + key + " " + (this.keys == null ? -1L : this.keys[i]));
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            this.freeRecursive();
            return true;
        }
        this.removeRow(i);
        this.index.getPageStore().update(this);
        return false;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        this.freeOverflow();
    }

    private void freeOverflow() {
        if (this.firstOverflowPageId != 0) {
            PageDataOverflow page;
            int next = this.firstOverflowPageId;
            do {
                page = this.index.getPageOverflow(next);
                page.free();
            } while ((next = page.getNextOverflow()) != 0);
        }
    }

    @Override
    Row getRowWithKey(long key) {
        int at = this.find(key);
        return this.getRowAt(at);
    }

    @Override
    int getRowCount() {
        return this.entryCount;
    }

    @Override
    void setRowCountStored(int rowCount) {
    }

    @Override
    long getDiskSpaceUsed() {
        return this.index.getPageStore().getPageSize();
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
        this.data.truncate(this.index.getPageStore().getPageSize());
    }

    private void readAllRows() {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRowAt(i);
        }
    }

    private void writeHead() {
        this.data.reset();
        int type = this.firstOverflowPageId == 0 ? 17 : 1;
        this.data.writeByte((byte)type);
        this.data.writeShortInt(0);
        if (SysProperties.CHECK2 && this.data.length() != 3) {
            DbException.throwInternalError();
        }
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeVarInt(this.columnCount);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int i;
        if (this.written) {
            return;
        }
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.writeHead();
        if (this.firstOverflowPageId != 0) {
            this.data.writeInt(this.firstOverflowPageId);
            this.data.checkCapacity(this.overflowRowSize);
        }
        for (i = 0; i < this.entryCount; ++i) {
            this.data.writeVarLong(this.keys[i]);
            this.data.writeShortInt(this.offsets[i]);
        }
        if (!this.writtenData || !this.optimizeUpdate) {
            for (i = 0; i < this.entryCount; ++i) {
                this.data.setPos(this.offsets[i]);
                Row r = this.getRowAt(i);
                for (int j = 0; j < this.columnCount; ++j) {
                    this.data.writeValue(r.getValue(j));
                }
            }
            this.writtenData = true;
        }
        this.written = true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf table:" + this.index.getId() + " " + this.index.getTable().getName() + " entries:" + this.entryCount + " parent:" + this.parentPageId + (this.firstOverflowPageId == 0 ? "" : " overflow:" + this.firstOverflowPageId) + " keys:" + Arrays.toString(this.keys) + " offsets:" + Arrays.toString(this.offsets);
    }

    @Override
    public void moveTo(Session session, int newPos) {
        PageStore store = this.index.getPageStore();
        if (this.parentPageId != 0) {
            store.getPage(this.parentPageId);
        }
        store.logUndo(this, this.data);
        PageDataLeaf p2 = PageDataLeaf.create(this.index, newPos, this.parentPageId);
        this.readAllRows();
        p2.keys = this.keys;
        p2.overflowRowSize = this.overflowRowSize;
        p2.firstOverflowPageId = this.firstOverflowPageId;
        p2.rowRef = this.rowRef;
        p2.rows = this.rows;
        if (this.firstOverflowPageId != 0) {
            p2.rows[0] = this.getRowAt(0);
        }
        p2.entryCount = this.entryCount;
        p2.offsets = this.offsets;
        p2.start = this.start;
        p2.remapChildren(this.getPos());
        p2.writeData();
        p2.data.truncate(this.index.getPageStore().getPageSize());
        store.update(p2);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, newPos);
        } else {
            PageDataNode p = (PageDataNode)store.getPage(this.parentPageId);
            p.moveChild(this.getPos(), newPos);
        }
        store.free(this.getPos());
    }

    void setOverflow(int old, int overflow) {
        if (SysProperties.CHECK && old != this.firstOverflowPageId) {
            DbException.throwInternalError("move " + this + " " + this.firstOverflowPageId);
        }
        this.index.getPageStore().logUndo(this, this.data);
        this.firstOverflowPageId = overflow;
        if (this.written) {
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.writeHead();
            this.data.writeInt(this.firstOverflowPageId);
        }
        this.index.getPageStore().update(this);
    }

    private void memoryChange(boolean add, Row r) {
        int diff = r == null ? 0 : 20 + r.getMemory();
        this.memoryData += add ? diff : -diff;
        this.index.memoryChange(240 + this.memoryData + this.index.getPageStore().getPageSize() >> 2);
    }

    @Override
    public boolean isStream() {
        return this.firstOverflowPageId > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row readRow(Data data, int pos, int columnCount) {
        Value[] values = new Value[columnCount];
        Data data2 = data;
        synchronized (data2) {
            data.setPos(pos);
            for (int i = 0; i < columnCount; ++i) {
                values[i] = data.readValue();
            }
        }
        return this.index.getDatabase().createRow(values, -1);
    }
}

