/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Query;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    CommandContainer(Parser parser, String sql, Prepared prepared) {
        super(parser, sql);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    @Override
    public void prepareJoinBatch() {
        if (this.session.isJoinBatchEnabled()) {
            CommandContainer.prepareJoinBatch(this.prepared);
        }
    }

    private static void prepareJoinBatch(Prepared prepared) {
        if (prepared.isQuery()) {
            if (prepared.getType() == 66) {
                ((Query)prepared).prepareJoinBatch();
            } else if (prepared.getType() == 60) {
                CommandContainer.prepareJoinBatch(((Explain)prepared).getCommand());
            }
        }
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String sql = this.prepared.getSQL();
            ArrayList<Parameter> oldParams = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(sql);
            long mod = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> newParams = this.prepared.getParameters();
            int size = newParams.size();
            for (int i = 0; i < size; ++i) {
                Parameter old = oldParams.get(i);
                if (!old.isValueSet()) continue;
                Value v = old.getValue(this.session);
                Parameter p = newParams.get(i);
                p.setValue(v);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(mod);
            this.prepareJoinBatch();
        }
    }

    @Override
    public int update() {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        int updateCount = this.prepared.update();
        this.prepared.trace(this.startTimeNanos, updateCount);
        this.setProgress(6);
        return updateCount;
    }

    @Override
    public ResultInterface query(int maxrows) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface result = this.prepared.query(maxrows);
        this.prepared.trace(this.startTimeNanos, result.getRowCount());
        this.setProgress(6);
        return result;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

