/*
 * Decompiled with CFR 0.152.
 */
package org.h2.api;

import java.io.Serializable;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;

public class TimestampWithTimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4413229090646777107L;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    public TimestampWithTimeZone(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
        this.timeZoneOffsetMins = timeZoneOffsetMins;
    }

    public long getYMD() {
        return this.dateValue;
    }

    public int getYear() {
        return DateTimeUtils.yearFromDateValue(this.dateValue);
    }

    public int getMonth() {
        return DateTimeUtils.monthFromDateValue(this.dateValue);
    }

    public int getDay() {
        return DateTimeUtils.dayFromDateValue(this.dateValue);
    }

    public long getNanosSinceMidnight() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        int y = DateTimeUtils.yearFromDateValue(this.dateValue);
        int month = DateTimeUtils.monthFromDateValue(this.dateValue);
        int d = DateTimeUtils.dayFromDateValue(this.dateValue);
        if (y > 0 && y < 10000) {
            StringUtils.appendZeroPadded(buff, 4, y);
        } else {
            buff.append(y);
        }
        buff.append('-');
        StringUtils.appendZeroPadded(buff, 2, month);
        buff.append('-');
        StringUtils.appendZeroPadded(buff, 2, d);
        buff.append(' ');
        long nanos = this.timeNanos;
        long ms = nanos / 1000000L;
        nanos -= ms * 1000000L;
        long s = ms / 1000L;
        ms -= s * 1000L;
        long min = s / 60L;
        s -= min * 60L;
        long h = min / 60L;
        StringUtils.appendZeroPadded(buff, 2, h);
        buff.append(':');
        StringUtils.appendZeroPadded(buff, 2, min -= h * 60L);
        buff.append(':');
        StringUtils.appendZeroPadded(buff, 2, s);
        buff.append('.');
        int start = buff.length();
        StringUtils.appendZeroPadded(buff, 3, ms);
        if (nanos > 0L) {
            StringUtils.appendZeroPadded(buff, 6, nanos);
        }
        for (int i = buff.length() - 1; i > start && buff.charAt(i) == '0'; --i) {
            buff.deleteCharAt(i);
        }
        short tz = this.timeZoneOffsetMins;
        if (tz < 0) {
            buff.append('-');
            tz = -tz;
        } else {
            buff.append('+');
        }
        int hours = tz / 60;
        short mins = tz = (short)(tz - hours * 60);
        StringUtils.appendZeroPadded(buff, 2, hours);
        if (mins != 0) {
            buff.append(':');
            StringUtils.appendZeroPadded(buff, 2, mins);
        }
        return buff.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.dateValue ^ this.dateValue >>> 32);
        result = 31 * result + (int)(this.timeNanos ^ this.timeNanos >>> 32);
        result = 31 * result + this.timeZoneOffsetMins;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampWithTimeZone other = (TimestampWithTimeZone)obj;
        if (this.dateValue != other.dateValue) {
            return false;
        }
        if (this.timeNanos != other.timeNanos) {
            return false;
        }
        return this.timeZoneOffsetMins == other.timeZoneOffsetMins;
    }
}

