/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.MimeUtil;

public abstract class SimpleContentHandler
extends AbstractContentHandler {
    private Header currHeader;

    public abstract void headers(Header var1);

    public abstract void bodyDecoded(BodyDescriptor var1, InputStream var2) throws IOException;

    @Override
    public final void startHeader() {
        this.currHeader = new Header();
    }

    @Override
    public final void field(Field field) throws MimeException {
        ParsedField parsedField = AbstractField.parse(field.getRaw());
        this.currHeader.addField(parsedField);
    }

    @Override
    public final void endHeader() {
        Header tmp = this.currHeader;
        this.currHeader = null;
        this.headers(tmp);
    }

    @Override
    public final void body(BodyDescriptor bd, InputStream is) throws IOException {
        if (MimeUtil.isBase64Encoding(bd.getTransferEncoding())) {
            this.bodyDecoded(bd, new Base64InputStream(is));
        } else if (MimeUtil.isQuotedPrintableEncoded(bd.getTransferEncoding())) {
            this.bodyDecoded(bd, new QuotedPrintableInputStream(is));
        } else {
            this.bodyDecoded(bd, is);
        }
    }
}

