/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.elytron.AuthenticationFactoryParser;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronSubsystemParser;
import org.wildfly.extension.elytron.HttpServerDefinitions;

class HttpParser {
    private final AuthenticationFactoryParser authenticationFactoryParser = new AuthenticationFactoryParser();

    HttpParser() {
    }

    void readHttp(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "http-authentication-factory": {
                    this.authenticationFactoryParser.readHttpAuthenticationFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
                case "aggregate-http-server-mechanism-factory": {
                    this.readAggregateHttpServerMechanismFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
                case "configurable-http-server-mechanism-factory": {
                    this.readConfigurableHttpServerMechanismFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
                case "provider-http-server-mechanism-factory": {
                    this.readProviderHttpServerMechanismFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
                case "service-loader-http-server-mechanism-factory": {
                    this.readServiceLoaderHttpServerMechanismFactoryElement(parentAddress, reader, operations);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readAggregateHttpServerMechanismFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("aggregate-http-server-mechanism-factory", name);
        operations.add(addOperation);
        ListAttributeDefinition httpServerFactories = HttpServerDefinitions.getRawAggregateHttpServerFactoryDefinition().getReferencesAttribute();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ElytronSubsystemParser.verifyNamespace(reader);
            String localName = reader.getLocalName();
            if (!"http-server-mechanism-factory".equals(localName)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
            String httpServerFactoryName = reader.getAttributeValue(0);
            httpServerFactories.parseAndAddParameterElement(httpServerFactoryName, addOperation, (XMLStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    }

    private void readConfigurableHttpServerMechanismFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "http-server-mechanism-factory"));
        String name = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = value;
                    continue block16;
                }
                case "http-server-mechanism-factory": {
                    HttpServerDefinitions.HTTP_SERVER_FACTORY.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        addOperation.get("address").set(parentAddress).add("configurable-http-server-mechanism-factory", name);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "filters": {
                    ModelNode filters = addOperation.get("filters");
                    this.parseFilters(filters, reader);
                    continue block17;
                }
                case "properties": {
                    ModelNode properties = addOperation.get("properties");
                    this.parseProperties(properties, reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(addOperation);
    }

    private void parseFilters(ModelNode filters, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "filter": {
                    this.parseFilter(filters, reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFilter(ModelNode filters, XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode filter = new ModelNode();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            String attribute;
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "enabling": {
                    HttpServerDefinitions.ENABLING.parseAndSetParameter(attributeValue, filter, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "pattern-filter": {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
                    String value = reader.getAttributeValue(0);
                    HttpServerDefinitions.PATTERN_FILTER.parseAndSetParameter(value, filter, (XMLStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        filters.add(filter);
    }

    private void parseProperties(ModelNode properties, XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String localName;
            ElytronSubsystemParser.verifyNamespace(reader);
            switch (localName = reader.getLocalName()) {
                case "property": {
                    this.parseProperty(properties, reader);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(ModelNode properties, XMLExtendedStreamReader reader) throws XMLStreamException {
        HashSet<String> requiredAttributes = new HashSet<String>(Arrays.asList("name", "value"));
        String key = null;
        String value = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attributeValue = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String attribute = reader.getAttributeLocalName(i);
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case "name": {
                    key = attributeValue;
                    continue block8;
                }
                case "value": {
                    value = attributeValue;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        properties.add(key, new ModelNode(value));
    }

    private void readProviderHttpServerMechanismFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "providers": {
                    HttpServerDefinitions.PROVIDERS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("provider-http-server-mechanism-factory", name);
        operations.add(addOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readServiceLoaderHttpServerMechanismFactoryElement(ModelNode parentAddress, XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attribute;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            switch (attribute = reader.getAttributeLocalName(i)) {
                case "name": {
                    name = value;
                    continue block8;
                }
                case "module": {
                    ClassLoadingAttributeDefinitions.MODULE.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{"name"});
        }
        addOperation.get("address").set(parentAddress).add("service-loader-http-server-mechanism-factory", name);
        operations.add(addOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void startHttp(boolean started, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (!started) {
            writer.writeStartElement("http");
        }
    }

    private boolean writeAggregateHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("aggregate-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            ModelNode aggregateHttpServerFactory = subsystem.require("aggregate-http-server-mechanism-factory");
            for (String name : aggregateHttpServerFactory.keys()) {
                ModelNode serverFactory = aggregateHttpServerFactory.require(name);
                writer.writeStartElement("aggregate-http-server-mechanism-factory");
                writer.writeAttribute("name", name);
                List serverFactoryReferences = serverFactory.get("http-server-mechanism-factories").asList();
                for (ModelNode currentReference : serverFactoryReferences) {
                    writer.writeStartElement("http-server-mechanism-factory");
                    writer.writeAttribute("name", currentReference.asString());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeConfigurableHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("configurable-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            ModelNode httpServerFactories = subsystem.require("configurable-http-server-mechanism-factory");
            for (String name : httpServerFactories.keys()) {
                ModelNode serverFactory = httpServerFactories.require(name);
                writer.writeStartElement("configurable-http-server-mechanism-factory");
                writer.writeAttribute("name", name);
                HttpServerDefinitions.HTTP_SERVER_FACTORY.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                CommonAttributes.PROPERTIES.marshallAsElement(serverFactory, (XMLStreamWriter)writer);
                if (serverFactory.hasDefined("filters")) {
                    writer.writeStartElement("filters");
                    List filters = serverFactory.require("filters").asList();
                    for (ModelNode currentFilter : filters) {
                        writer.writeStartElement("filter");
                        HttpServerDefinitions.ENABLING.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                        if (currentFilter.hasDefined("pattern-filter")) {
                            writer.writeStartElement("pattern-filter");
                            HttpServerDefinitions.PATTERN_FILTER.marshallAsAttribute(currentFilter, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeProviderHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("provider-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            ModelNode serverFactories = subsystem.require("provider-http-server-mechanism-factory");
            for (String name : serverFactories.keys()) {
                ModelNode serverFactory = serverFactories.require(name);
                writer.writeStartElement("provider-http-server-mechanism-factory");
                writer.writeAttribute("name", name);
                HttpServerDefinitions.PROVIDERS.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    private boolean writeServiceLoaderHttpServerMechanismFactory(boolean started, ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (subsystem.hasDefined("service-loader-http-server-mechanism-factory")) {
            this.startHttp(started, writer);
            ModelNode serverFactories = subsystem.require("service-loader-http-server-mechanism-factory");
            for (String name : serverFactories.keys()) {
                ModelNode serverFactory = serverFactories.require(name);
                writer.writeStartElement("service-loader-http-server-mechanism-factory");
                writer.writeAttribute("name", name);
                ClassLoadingAttributeDefinitions.MODULE.marshallAsAttribute(serverFactory, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            return true;
        }
        return false;
    }

    void writeHttp(ModelNode subsystem, XMLExtendedStreamWriter writer) throws XMLStreamException {
        boolean started = false;
        started |= this.authenticationFactoryParser.writeHttpAuthenticationFactory(started, subsystem, writer, b -> this.startHttp(b, writer));
        started |= this.writeAggregateHttpServerMechanismFactory(started, subsystem, writer);
        started |= this.writeConfigurableHttpServerMechanismFactory(started, subsystem, writer);
        started |= this.writeProviderHttpServerMechanismFactory(started, subsystem, writer);
        if (started |= this.writeServiceLoaderHttpServerMechanismFactory(started, subsystem, writer)) {
            writer.writeEndElement();
        }
    }
}

