/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.cond.Apply;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.ExpressionHandler;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Condition
implements Evaluatable {
    private static URI booleanIdentifier;
    private List children;
    private Expression expression;
    private Function function;
    private boolean isVersionOne;

    public Condition(Function function, List expressions) throws IllegalArgumentException {
        this.isVersionOne = true;
        this.checkExpression(function);
        this.expression = new Apply(function, expressions);
        this.function = function;
        this.children = ((Apply)this.expression).getChildren();
    }

    public Condition(Expression expression) throws IllegalArgumentException {
        this.isVersionOne = false;
        this.checkExpression(expression);
        this.expression = expression;
        this.function = null;
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(this.expression);
        this.children = Collections.unmodifiableList(list);
    }

    private void checkExpression(Expression xpr) {
        if (!xpr.getType().equals(booleanIdentifier)) {
            throw new IllegalArgumentException("A Condition must return a boolean...cannot create with " + xpr.getType());
        }
        if (xpr.returnsBag()) {
            throw new IllegalArgumentException("A Condition must not return a Bag");
        }
    }

    public static Condition getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        if (metaData.getXACMLVersion() < 2) {
            Apply cond = Apply.getConditionInstance(root, metaData.getXPathIdentifier(), manager);
            return new Condition(cond.getFunction(), cond.getChildren());
        }
        Expression xpr = null;
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            break;
        }
        return new Condition(xpr);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public URI getType() {
        return booleanIdentifier;
    }

    @Override
    public boolean returnsBag() {
        return false;
    }

    @Override
    public boolean evaluatesToBag() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return ((Evaluatable)this.expression).evaluate(context);
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        if (this.isVersionOne) {
            out.println(indent + "<Condition FunctionId=\"" + this.function.getIdentifier() + "\">");
            indenter.in();
            for (Expression xpr : this.children) {
                xpr.encode(output, indenter);
            }
        } else {
            out.println(indent + "<Condition>");
            indenter.in();
            this.expression.encode(output, indenter);
        }
        indenter.out();
        out.println(indent + "</Condition>");
    }

    static {
        try {
            booleanIdentifier = new URI("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (Exception e) {
            booleanIdentifier = null;
        }
    }
}

